import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';


class NotifikasiAkunApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();


  Future<StatusPengajuanDataRespon> getStatusPengajuan() async {
    var respon = await dio.get("notifikasi_akun/status-pengajuan", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return StatusPengajuanDataResponFromJson(respon.data);
    } else {
      return StatusPengajuanDataRespon();
    }
  }

  Future<JumlahBadge> getBadgeAkun() async {
    var respon = await dio.get("notifikasi_akun/badge", options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return jumlahBadgeFromJson(respon.data);
    } else {
      return JumlahBadge(success: false);
    }
  }

  Future<BasicRespon> baca(String? idNotif) async {
    var respon = await dio.patch("notifikasi_akun/baca", queryParameters: {"id_notif": idNotif},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  // Future<NotifikasiAkunDataDiriRespon> getNotifikasiDataDiri(id) async {
  //   LoginRespon data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("notifikasi_akun/data_diri", queryParameters: {
  //     "id_company": data.dataLogin.idCompany,
  //     "id_karyawan": data.dataLogin.idKaryawan,
  //     "limit": ServerInfo.limit,
  //     "offset": 0,
  //     "id": id
  //   });
  //   if (respon.statusCode == 200) {
  //     return notifikasiAkunDataDiriResponFromJson(respon.data);
  //   } else {
  //     return null;
  //   }
  // }
  //
  // Future<DataKeluargaRespon> getNotifikasiDataKeluarga(id) async {
  //   LoginRespon data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("notifikasi_akun/data_keluarga", queryParameters: {
  //     "id_company": data.dataLogin.idCompany,
  //     "id_karyawan": data.dataLogin.idKaryawan,
  //     "limit": ServerInfo.limit,
  //     "offset": 0,
  //     "id": id
  //   });
  //   if (respon.statusCode == 200) {
  //     return dataKeluargaResponFromJson(respon.data);
  //   } else {
  //     return null;
  //   }
  // }
  //
  // Future<PendidikanRespon> getNotifikasiDataPendidikan(id) async {
  //   LoginRespon data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("notifikasi_akun/data_pendidikan", queryParameters: {
  //     "id_company": data.dataLogin.idCompany,
  //     "id_karyawan": data.dataLogin.idKaryawan,
  //     "limit": ServerInfo.limit,
  //     "offset": 0,
  //     "id": id
  //   });
  //   if (respon.statusCode == 200) {
  //     return dataPendidikanResponFromJson(respon.data);
  //   } else {
  //     return null;
  //   }
  // }
  //
  // Future<PekerjaanRespon> getNotifikasiDataPeKerjaan(id) async {
  //   LoginRespon data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("notifikasi_akun/data_pekerjaan", queryParameters: {
  //     "id_company": data.dataLogin.idCompany,
  //     "id_karyawan": data.dataLogin.idKaryawan,
  //     "limit": ServerInfo.limit,
  //     "offset": 0,
  //     "id": id
  //   });
  //   if (respon.statusCode == 200) {
  //     return dataPekerjaanResponFromJson(respon.data);
  //   } else {
  //     return null;
  //   }
  // }
  //
  // Future<KarirRespon> getNotifikasiDataKarir(id) async {
  //   LoginRespon data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("notifikasi_akun/data_karir", queryParameters: {
  //     "id_company": data.dataLogin.idCompany,
  //     "id_karyawan": data.dataLogin.idKaryawan,
  //     "limit": ServerInfo.limit,
  //     "offset": 0,
  //     "id": id
  //   });
  //   if (respon.statusCode == 200) {
  //     return dataKarirResponFromJson(respon.data);
  //   } else {
  //     return null;
  //   }
  // }
  //
  // Future<TrainingRespon> getNotifikasiDataSertifikat(id) async {
  //   LoginRespon data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("notifikasi_akun/data_sertifikat", queryParameters: {
  //     "id_company": data.dataLogin.idCompany,
  //     "id_karyawan": data.dataLogin.idKaryawan,
  //     "limit": ServerInfo.limit,
  //     "offset": 0,
  //     "id": id
  //   });
  //   if (respon.statusCode == 200) {
  //     return dataTrainingResponFromJson(respon.data);
  //   } else {
  //     return null;
  //   }
  // }

  Future<NotifikasiAkunRespon> getDataNotifikasiAkun(int offset) async {
    var respon = await dio.get("notifikasi_akun/data", queryParameters: {
      "limit": ServerInfo.limit,
      "offset": offset
    }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataNotifikasiAkunResponFromJson(respon.data);
    } else {
      return NotifikasiAkunRespon(success: false);
    }
  }
}
