import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikan.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikanById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel2.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class DataPendidikanApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();




  Future<DataPendidikanRespon> getDataPendidikanTerferifikasi() async {
    var respon = await dio.get("data_pendidikan/data", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPendidikanResponFromJson(respon.data);
    } else {
      return DataPendidikanRespon(success: false);
    }
  }

  Future<DataPendidikanRespon> getDataPendidikanPengajuan() async {
    var respon = await dio.get("data_pendidikan/data-pengajuan", options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataPendidikanResponFromJson(respon.data);
    } else {
      return DataPendidikanRespon(success: false);
    }
  }

  Future<DataPendidikanByIdRespon> getDataPendidikanPengajuanById(idPendidikan, konteks) async {
    var respon = await dio.get("data_pendidikan/data-pengajuan-by-id",
        queryParameters: {
          "id_pendidikan": idPendidikan,
          "konteks": konteks
        }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataPendidikanByIdResponFromJson(respon.data);
    } else {
      return DataPendidikanByIdRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanTambahDataPendidikan(DataDatapendidikan dataPendidikan, List<MultiImagePickerModel>? ijazah, List<MultiImagePickerModel2>? transkrip) async {
    var respon = await dio.post("data_pendidikan/tambah", data: {
      "jenjang": dataPendidikan.jenjang,
      "nama_sekolah" : dataPendidikan.namaSekolah,
      "jurusan" : dataPendidikan.jurusan,
      "lulusan_asal" : dataPendidikan.lulusanAsal,
      "tahun_masuk" : dataPendidikan.tahunMasuk,
      "tahun_lulus" : dataPendidikan.tahunLulus,
      "gelar" : dataPendidikan.gelar,
      "ijazah" : ijazah==null?null:ijazah.length==0?null:ijazah[0].base64,
      "transkrip" : transkrip==null?null:transkrip.length==0?null:transkrip[0].base64
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editPengajuanDataPendidikan(DataDatapendidikan dataPendidikan, List<MultiImagePickerModel>? ijazah, List<MultiImagePickerModel2>? transkrip) async {
    var respon = await dio.post("data_pendidikan/edit-pengajuan", data: {
      "id_pendidikan": dataPendidikan.idPendidikan,
      "jenjang": dataPendidikan.jenjang,
      "nama_sekolah" : dataPendidikan.namaSekolah,
      "jurusan" : dataPendidikan.jurusan,
      "lulusan_asal" : dataPendidikan.lulusanAsal,
      "tahun_masuk" : dataPendidikan.tahunMasuk,
      "tahun_lulus" : dataPendidikan.tahunLulus,
      "gelar" : dataPendidikan.gelar,
      "ijazah_old" : dataPendidikan.ijazah,
      "ijazah" : ijazah==null?null:ijazah.length==0?null:ijazah[0].base64,
      "transkrip_old" : dataPendidikan.transkrip,
      "transkrip" : transkrip==null?null:transkrip.length==0?null:transkrip[0].base64
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editDataPendidikan(DataDatapendidikan dataPendidikan, List<MultiImagePickerModel>? ijazah, List<MultiImagePickerModel2>? transkrip) async {
    var respon = await dio.post("data_pendidikan/edit", data: {
      "id_pendidikan": dataPendidikan.idPendidikan,
      "jenjang": dataPendidikan.jenjang,
      "nama_sekolah" : dataPendidikan.namaSekolah,
      "jurusan" : dataPendidikan.jurusan,
      "lulusan_asal" : dataPendidikan.lulusanAsal,
      "tahun_masuk" : dataPendidikan.tahunMasuk,
      "tahun_lulus" : dataPendidikan.tahunLulus,
      "gelar" : dataPendidikan.gelar,
      "ijazah_old" : dataPendidikan.ijazah,
      "ijazah" : ijazah==null?null:ijazah.length==0?null:ijazah[0].base64,
      "transkrip_old" : dataPendidikan.transkrip,
      "transkrip" : transkrip==null?null:transkrip.length==0?null:transkrip[0].base64
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deleteDataPendidikan(String idPendidikan) async {
    var respon = await dio.delete("data_pendidikan/delete", queryParameters: {
      "id_pendidikan": idPendidikan
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deletePengajuanDataPendidikan(String idPendidikan) async {
    var respon = await dio.delete("data_pendidikan/delete-pengajuan", queryParameters: {
      "id_pendidikan": idPendidikan
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataPendidikanRespon> getDetailDataPendidikanById(DataNotifikasiAkun data) async {
    var respon = await dio.get("data_pendidikan/data-detail-by-id",
        queryParameters: { "id": data.id, "konteks": data.jenis }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataPendidikanResponFromJson(respon.data);
    } else {
      return DataPendidikanRespon(success: false);
    }
  }


}
