import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluarga.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluargaById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class DataKeluargaApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();




  Future<DataKeluargaRespon> getDataKeluargaTerferifikasi() async {
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.get("data_keluarga/data", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataKeluargaResponFromJson(respon.data);
    } else {
      return DataKeluargaRespon(success: false);
    }
  }

  Future<DataKeluargaRespon> getDataKeluargaPengajuan() async {
    LoginRespon data = await sharedPreferences().getUserData();

    var respon = await dio.get("data_keluarga/data-pengajuan", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataKeluargaResponFromJson(respon.data);
    } else {
      return DataKeluargaRespon(success: false);
    }
  }

  Future<DataKeluargaByIdRespon> getDataKeluargaPengajuanById(idKeluarga, konteks) async {
    print("jjj :$konteks");
    var respon = await dio.get("data_keluarga/data-pengajuan-by-id",
        queryParameters: {
          "id_keluarga": idKeluarga,
          "konteks": konteks
        }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataKeluargaByIdResponFromJson(respon.data);
    } else {
      return DataKeluargaByIdRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanTambahDataKeluarga(DataDatakeluarga dataKeluarga) async {
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.post("data_keluarga/tambah", data: {
      "nik": dataKeluarga.nik,
      "nama" : dataKeluarga.namaLengkap,
      "tempat_lahir" : dataKeluarga.tempatLahir,
      "tanggal_lahir" : dataKeluarga.tglLahir,
      "jenis_kelamin" : dataKeluarga.jenisKelamin,
      "agama" : dataKeluarga.agama,
      "pendidikan_terakhir" : dataKeluarga.pendidikanTerakhir,
      "pekerjaan" : dataKeluarga.pekerjaan,
      "telepon" : dataKeluarga.telepon,
      "status" : dataKeluarga.status,
      "hub_keluarga" : dataKeluarga.hubKeluarga,
      "status_perkawinan" : dataKeluarga.statusPerkawinan,
      "no_bpjs" : dataKeluarga.noBpjs,
      "tanggal_perkawinan" : dataKeluarga.tanggalPerkawinan!=null?dataKeluarga.tanggalPerkawinan:null
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editPengajuanDataKeluarga(DataDatakeluarga dataKeluarga) async {
    var respon = await dio.post("data_keluarga/edit-pengajuan", data: {
      "id_keluarga": dataKeluarga.idKeluarga,
      "nik": dataKeluarga.nik,
      "nama" : dataKeluarga.namaLengkap,
      "tempat_lahir" : dataKeluarga.tempatLahir,
      "tanggal_lahir" : dataKeluarga.tglLahir,
      "jenis_kelamin" : dataKeluarga.jenisKelamin,
      "agama" : dataKeluarga.agama,
      "pendidikan_terakhir" : dataKeluarga.pendidikanTerakhir,
      "pekerjaan" : dataKeluarga.pekerjaan,
      "telepon" : dataKeluarga.telepon,
      "status" : dataKeluarga.status,
      "hub_keluarga" : dataKeluarga.hubKeluarga,
      "status_perkawinan" : dataKeluarga.statusPerkawinan,
      "no_bpjs" : dataKeluarga.noBpjs,
      "tanggal_perkawinan" : dataKeluarga.tanggalPerkawinan!=null?dataKeluarga.tanggalPerkawinan:null
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editDataKeluarga(DataDatakeluarga dataKeluarga) async {
    LoginRespon data = await sharedPreferences().getUserData();
    print("kkk : ${dataKeluarga.idKeluarga}");
    var respon = await dio.post("data_keluarga/edit", data: {
      "id_keluarga": dataKeluarga.idKeluarga,
      "nik": dataKeluarga.nik,
      "nama" : dataKeluarga.namaLengkap,
      "tempat_lahir" : dataKeluarga.tempatLahir,
      "tanggal_lahir" : dataKeluarga.tglLahir,
      "jenis_kelamin" : dataKeluarga.jenisKelamin,
      "agama" : dataKeluarga.agama,
      "pendidikan_terakhir" : dataKeluarga.pendidikanTerakhir,
      "pekerjaan" : dataKeluarga.pekerjaan,
      "telepon" : dataKeluarga.telepon,
      "status" : dataKeluarga.status,
      "hub_keluarga" : dataKeluarga.hubKeluarga,
      "status_perkawinan" : dataKeluarga.statusPerkawinan,
      "no_bpjs" : dataKeluarga.noBpjs,
      "tanggal_perkawinan" : dataKeluarga.tanggalPerkawinan!=null?dataKeluarga.tanggalPerkawinan:null
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deleteDataKeluarga(String idKeluarga) async {
    var respon = await dio.delete("data_keluarga/delete", queryParameters: {
      "id_keluarga": idKeluarga
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deletePengajuanDataKeluarga(String idKeluarga) async {
    var respon = await dio.delete("data_keluarga/delete-pengajuan", queryParameters: {
      "id_keluarga": idKeluarga
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataKeluargaRespon> getDetailDataKeluargaById(DataNotifikasiAkun data) async {
    var respon = await dio.get("data_keluarga/data-detail-by-id",
        queryParameters: { "id_keluarga": data.id, "konteks": data.jenis }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataKeluargaResponFromJson(respon.data);
    } else {
      return DataKeluargaRespon(success: false);
    }
  }

}
