import 'dart:convert';

PengajuanSaya pengajuanSayaFromJson(String str) => PengajuanSaya.fromJson(json.decode(str));

String pengajuanSayaToJson(PengajuanSaya data) => json.encode(data.toJson());

class PengajuanSaya {
    bool? success;
    String? message;
    List<DataPengajuanSaya>? data;

    PengajuanSaya({
        this.success,
        this.message,
        this.data,
    });

    factory PengajuanSaya.fromJson(Map<String, dynamic> json) => PengajuanSaya(
        success: json["success"],
        message: json["message"],
        data: List<DataPengajuanSaya>.from(json["data"].map((x) => DataPengajuanSaya.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
    };
}

class DataPengajuanSaya {
    String? idPengajuan;
    String? noPengajuan;
    String? tglPengajuan;
    String? tglPengajuanRaw;
    String? idKaryawan;
    String? namaLengkap;
    String? tglShift;
    Shift? shiftAwal;
    Shift? shiftBaru;
    String? keterangan;
    Status? status;
    bool? button;
    String? ketButton;
    List<ListApproval>? listApproval;

    DataPengajuanSaya({
        this.idPengajuan,
        this.noPengajuan,
        this.tglPengajuan,
        this.tglPengajuanRaw,
        this.idKaryawan,
        this.namaLengkap,
        this.tglShift,
        this.shiftAwal,
        this.shiftBaru,
        this.keterangan,
        this.status,
        this.button,
        this.ketButton,
        this.listApproval
    });

    factory DataPengajuanSaya.fromJson(Map<String, dynamic> json) => DataPengajuanSaya(
        idPengajuan: json["id_pengajuan"],
        noPengajuan:json["no_pengajuan"],
        tglPengajuan: json["tgl_pengajuan"],
        tglPengajuanRaw: json["tgl_pengajuan_raw"],
        idKaryawan: json["id_karyawan"],
        namaLengkap: json["nama_lengkap"],
        tglShift: json["tgl_shift"],
        shiftAwal: Shift.fromJson(json["shift_awal"]),
        shiftBaru: Shift.fromJson(json["shift_baru"]),
        keterangan: json["keterangan"],
        status: Status.fromJson(json["status"]),
        button: json["button"],
        ketButton: json["ket_button"],
        listApproval: json["list_approval"] == null
            ? null
            : List<ListApproval>.from(
            json["list_approval"].map((x) => ListApproval.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "id_pengajuan": idPengajuan,
        "no_pengajuan": noPengajuan,
        "tgl_pengajuan": tglPengajuan,
        "tgl_pengajuan_raw": tglPengajuanRaw,
        "id_karyawan": idKaryawan,
        "nama_lengkap": namaLengkap,
        "tgl_shift": tglShift,
        "shift_awal": shiftAwal!.toJson(),
        "shift_baru": shiftBaru!.toJson(),
        "keterangan": keterangan,
        "status": status!.toJson(),
        "button": button,
        "ket_button": ketButton,
        "list_approval": listApproval == null
            ? null
            : List<dynamic>.from(listApproval!.map((x) => x.toJson())),
    };
}

class ListApproval {
    ListApproval(
        {this.statusApproval,
            this.tanggalApproval,
            this.warnaStatus,
            this.warnaFont});

    String? statusApproval;
    dynamic tanggalApproval;
    String? warnaStatus;
    String? warnaFont;

    factory ListApproval.fromJson(Map<String, dynamic> json) => ListApproval(
        statusApproval:
        json["status_approval"] == null ? null : json["status_approval"],
        tanggalApproval: json["tanggal_approval"],
        warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
        warnaFont: json["warna_font"] == null ? null : json["warna_font"],
    );

    Map<String, dynamic> toJson() => {
        "status_approval": statusApproval == null ? null : statusApproval,
        "tanggal_approval": tanggalApproval,
        "warna_status": warnaStatus == null ? null : warnaStatus,
        "warna_font": warnaFont == null ? null : warnaFont,
    };
}

class Shift {
    String? kodeShift;
    String? namaShift;
    String? masuk;
    String? pulang;
    String? karyawan;
    String? nik;

    Shift({
        this.kodeShift,
        this.namaShift,
        this.masuk,
        this.pulang,
        this.karyawan,
        this.nik,
    });

    factory Shift.fromJson(Map<String, dynamic> json) => Shift(
        kodeShift: json["kode_shift"],
        namaShift: json["nama_shift"],
        masuk: json["masuk"],
        pulang: json["pulang"],
        karyawan: json["karyawan"],
        nik: json["nik"],
    );

    Map<String, dynamic> toJson() => {
        "kode_shift": kodeShift,
        "nama_shift": namaShift,
        "masuk": masuk,
        "pulang": pulang,
        "karyawan": karyawan,
        "nik": nik,
    };
}

class Status {
    String? status;
    String? color;
    String? fontColor;

    Status({
        this.status,
        this.color,
        this.fontColor,
    });

    factory Status.fromJson(Map<String, dynamic> json) => Status(
        status: json["status"],
        color: json["color"],
        fontColor: json["font_color"],
    );

    Map<String, dynamic> toJson() => {
        "status": status,
        "color": color,
        "font_color": fontColor,
    };
}
