// To parse this JSON data, do
//
//     final dropdownLokasi = dropdownLokasiFromJson(jsonString);

import 'dart:convert';

DropdownLokasi dropdownLokasiFromJson(String str) =>
    DropdownLokasi.fromJson(json.decode(str));

String dropdownLokasiToJson(DropdownLokasi data) => json.encode(data.toJson());

class DropdownLokasi {
  bool? success;
  String? message;
  List<DataLokasi>? data;

  DropdownLokasi({
    this.success,
    this.message,
    this.data,
  });

  factory DropdownLokasi.fromJson(Map<String, dynamic> json) => DropdownLokasi(
        success: json["success"],
        message: json["message"],
        data: json["data"] == null
            ? []
            : List<DataLokasi>.from(
                json["data"].map((x) => DataLokasi.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataLokasi {
  String? namaKantor;
  String? latAsli;
  String? longAsli;

  DataLokasi({
    this.namaKantor,
    this.latAsli,
    this.longAsli,
  });

  factory DataLokasi.fromJson(Map<String, dynamic> json) => DataLokasi(
        namaKantor: json["nama_kantor"],
        latAsli: json["lat_asli"],
        longAsli: json["long_asli"],
      );

  Map<String, dynamic> toJson() => {
        "nama_kantor": namaKantor,
        "lat_asli": latAsli,
        "long_asli": longAsli,
      };
}
