import 'dart:convert';

CheckpointRespon checkpointResponFromJson(String str) =>
    CheckpointRespon.fromJson(json.decode(str));
String checkpointResponToJson(CheckpointRespon data) =>
    json.encode(data.toJson());

class CheckpointRespon {
  bool? success;
  String? message;
  List<DataChekpoint>? data;

  CheckpointRespon({this.success, this.message, this.data});

  CheckpointRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <DataChekpoint>[];
      json['data'].forEach((v) {
        data!.add(new DataChekpoint.fromJson(v));
      });
    }
  }
  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataChekpoint {
  String? idChekpoint;
  String? idKaryawan;
  String? namaKaryawan;
  String? keterangan;
  String? tanggalRaw;
  String? hari;
  String? tanggal;
  String? bulan;
  String? waktu;
  String? namajabatan;
  String? namaDepartemen;
  String? namaCabang;
  String? lokasi;
  String? latitude;
  String? longitude;
  String? nm_qr;
  String? image;
  DataChekpoint(
      {this.idChekpoint,
      this.idKaryawan,
      this.namaKaryawan,
      this.keterangan,
      this.tanggalRaw,
      this.hari,
      this.tanggal,
      this.bulan,
      this.waktu,
      this.namajabatan,
      this.namaDepartemen,
      this.namaCabang,
      this.lokasi,
      this.latitude,
      this.nm_qr,
      this.longitude,
      this.image});
  DataChekpoint.fromJson(Map<String, dynamic> json) {
    idChekpoint = json['id_patroli'];
    idKaryawan = json['id_karyawan'];
    keterangan = json['ket_cp'];
    namaKaryawan = json['nama_karyawan'];
    tanggalRaw = json['tanggal_raw'];
    hari = json['hari'];
    tanggal = json['tanggal'];
    bulan = json['bulan'];
    waktu = json['waktu'];
    nm_qr = json['nm_qr'];
    namajabatan = json['namajabatan'];
    namaDepartemen = json['nama_departemen'];
    namaCabang = json['nama_cabang'];
    lokasi = json['lokasi'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    keterangan = json['keterangan'];
    image = json['image'];
  }
  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_patroli'] = this.idChekpoint;
    data['id_karyawan'] = this.idKaryawan;
    data['nama_karyawan'] = this.namaKaryawan;
    data['tanggal_raw'] = this.tanggalRaw;
    data['hari'] = this.hari;
    data['tanggal'] = this.tanggal;
    data['bulan'] = this.bulan;
    data['waktu'] = this.waktu;
    data['namajabatan'] = this.namajabatan;
    data['nama_departemen'] = this.namaDepartemen;
    data['nama_cabang'] = this.namaCabang;
    data['lokasi'] = this.lokasi;
    data['latitude'] = this.latitude;
    data['nm_qr'] = this.nm_qr;
    data['longitude'] = this.longitude;
    data['ket_cp'] = this.keterangan;
    data['image'] = this.image;
    return data;
  }
}

CekLokasiRespon cekLokasiResponFromJson(String str) =>
    CekLokasiRespon.fromJson(json.decode(str));
String cekLokasiResponToJson(CekLokasiRespon data) =>
    json.encode(data.toJson());

class CekLokasiRespon {
  CekLokasiRespon({
    this.success,
    this.message,
    this.tanggal,
    this.cekLokasi,
  });

  bool? success;
  String? message;
  String? tanggal;
  CekLokasi? cekLokasi;

  factory CekLokasiRespon.fromJson(Map<String, dynamic> json) =>
      CekLokasiRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        tanggal: json["tanggal"] == null ? null : json["tanggal"],
        cekLokasi: json["CekLokasi"] == null
            ? null
            : CekLokasi.fromJson(json["CekLokasi"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "message": message == null ? null : message,
        "tanggal": tanggal == null ? null : tanggal,
        "CekLokasi": cekLokasi == null ? null : cekLokasi!.toJson(),
      };
}

class JadwalChekpointRespone {
  bool? success;
  String? message;
  List<JadwalChekpoint>? data;

  JadwalChekpointRespone({this.success, this.message, this.data});

  JadwalChekpointRespone.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <JadwalChekpoint>[];
      json['data'].forEach((v) {
        data!.add(new JadwalChekpoint.fromJson(v));
      });
    }
  }
  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}
JadwalChekpointRespone jadwalCheckpointResponFromJson(String str) =>
    JadwalChekpointRespone.fromJson(json.decode(str));
String jadwalCheckpointResponToJson(JadwalChekpointRespone data) =>
    json.encode(data.toJson());
class JadwalChekpoint {
  JadwalChekpoint(
      {this.idCabang,
      this.idCompany,
      this.nmJadwal,
      this.minAbsen,
      this.maxAbsen,
      this.isActive});
  String? idCabang;
  String? idCompany;
  String? nmJadwal;
  String? minAbsen;
  String? maxAbsen;
  bool? isActive;
  factory JadwalChekpoint.fromJson(Map<String, dynamic> json) =>
      JadwalChekpoint(
        idCabang: json["id_cabang"] == null ? null : json["id_cabang"],
        idCompany: json["id_company"] == null ? null : json["id_company"],
        nmJadwal: json["nm_jadwal"] == null ? null : json["nm_jadwal"],
        minAbsen: json["min_absen"] == null ? null : json["min_absen"],
        maxAbsen: json["max_absen"] == null ? null : json["max_absen"],
        isActive: json["is_active"] == null ? null : json["is_active"],
      );
  Map<String, dynamic> toJson() => {
        "id_cabang": idCabang == null ? null : idCabang,
        "id_company": idCompany == null ? null : idCompany,
        "nm_jadwal": nmJadwal == null ? null : nmJadwal,
        "min_absen": minAbsen == null ? null : minAbsen,
        "max_absen": maxAbsen == null ? null : maxAbsen,
        "is_active": isActive == null ? null : isActive,
      };
}

class CekLokasi {
  CekLokasi({
    this.status,
    this.lockLokasi,
    this.bolehAbsen,
    this.namaLokasi,
    this.ketLokasi,
  });

  bool? status;
  bool? lockLokasi;
  bool? bolehAbsen;
  String? namaLokasi;
  String? ketLokasi;

  factory CekLokasi.fromJson(Map<String, dynamic> json) => CekLokasi(
        status: json["status"] == null ? null : json["status"],
        lockLokasi: json["lock_lokasi"] == null ? null : json["lock_lokasi"],
        bolehAbsen: json["boleh_absen"] == null ? null : json["boleh_absen"],
        namaLokasi: json["nama_lokasi"] == null ? null : json["nama_lokasi"],
        ketLokasi: json["ket_lokasi"] == null ? null : json["ket_lokasi"],
      );

  Map<String, dynamic> toJson() => {
        "status": status == null ? null : status,
        "lock_lokasi": lockLokasi == null ? null : lockLokasi,
        "boleh_absen": bolehAbsen == null ? null : bolehAbsen,
        "nama_lokasi": namaLokasi == null ? null : namaLokasi,
        "ket_lokasi": ketLokasi == null ? null : ketLokasi,
      };
}

class DataAbsensi {
  String? idKaryawan;
  String? idCompany;
  String? jenisAbsen; // MASUK / PULANG / IST / DLL
  String? lokasiAbsen; // NAMA KANTORNYA
  String? latitude;
  String? longitude;
  String? tipeAbsen; // REG / LIBUR
  String? kodeAbsen; //H / I / C / DLL
  String? ketKodeAbsen; //Hadir / Izin / DLL
  String? jamKerja; // jam masuk - pulang
  String? keteranganAbsen;
  String? foto;
  String? qr;
  String? minAbsen;
  String? maxAbsen;
  String? nmJadwal;


  DataAbsensi(
      {this.idKaryawan,
      this.idCompany,
      this.jenisAbsen,
      this.lokasiAbsen,
      this.latitude,
      this.longitude,
      this.tipeAbsen,
      this.kodeAbsen,
      this.ketKodeAbsen,
      this.jamKerja,
      this.keteranganAbsen,
      this.foto,
      this.qr,
      this.minAbsen,
      this.maxAbsen,
      this.nmJadwal});
}
