import 'dart:convert';

TotalDataLayananRespon totalDataLayananResponFromJson(String str) => TotalDataLayananRespon.fromJson(json.decode(str));

String totalDataLayananResponToJson(TotalDataLayananRespon data) => json.encode(data.toJson());

class TotalDataLayananRespon {
  bool? success;
  String? message;
  TotalDataLayananDetail? totalDataLayananDetail;

  TotalDataLayananRespon(
      {this.success, this.message, this.totalDataLayananDetail});

  TotalDataLayananRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    totalDataLayananDetail = json['total_data_layanan_detail'] != null
        ? new TotalDataLayananDetail.fromJson(json['total_data_layanan_detail'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.totalDataLayananDetail != null) {
      data['total_data_layanan_detail'] = this.totalDataLayananDetail!.toJson();
    }
    return data;
  }
}

class TotalDataLayananDetail {
  String? idPipelineMain;
  String? idKaryawan;
  String? namaLengkap;
  String? totalHarga;
  String? layanan;
  String? totalItem;
  String? totalDiskon;

  TotalDataLayananDetail(
      {this.idPipelineMain,
        this.idKaryawan,
        this.namaLengkap,
        this.totalHarga,
        this.layanan,
        this.totalItem,
        this.totalDiskon});

  TotalDataLayananDetail.fromJson(Map<String, dynamic> json) {
    idPipelineMain = json['id_pipeline_main'];
    idKaryawan = json['id_karyawan'];
    namaLengkap = json['nama_lengkap'];
    totalHarga = json['total_harga'];
    layanan = json['layanan'];
    totalItem = json['total_item'];
    totalDiskon = json['total_diskon'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pipeline_main'] = this.idPipelineMain;
    data['id_karyawan'] = this.idKaryawan;
    data['nama_lengkap'] = this.namaLengkap;
    data['total_harga'] = this.totalHarga;
    data['layanan'] = this.layanan;
    data['total_item'] = this.totalItem;
    data['total_diskon'] = this.totalDiskon;
    return data;
  }
}
