import 'dart:convert';

JenisAktivitasSalesRespon jenisAktivitasSalesResponFromJson(String str) => JenisAktivitasSalesRespon.fromJson(json.decode(str));

String jenisAktivitasSalesResponToJson(JenisAktivitasSalesRespon data) => json.encode(data.toJson());

class JenisAktivitasSalesRespon {
  bool? success;
  String? message;
  List<Data>? data;

  JenisAktivitasSalesRespon({this.success, this.message, this.data});

  JenisAktivitasSalesRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <Data>[];
      json['data'].forEach((v) {
        data!.add(new Data.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Data {
  String? idActivityM;
  String? nama;
  int? poin;
  String? flagLokasi;
  String? flagUploadFoto;
  String? idCompany;

  Data(
      {this.idActivityM,
        this.nama,
        this.poin,
        this.flagLokasi,
        this.flagUploadFoto,
        this.idCompany});

  Data.fromJson(Map<String, dynamic> json) {
    idActivityM = json['id_activity_m'];
    nama = json['nama'];
    poin = json['poin'];
    flagLokasi = json['flag_lokasi'];
    flagUploadFoto = json['flag_upload_foto'];
    idCompany = json['id_company'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_activity_m'] = this.idActivityM;
    data['nama'] = this.nama;
    data['poin'] = this.poin;
    data['flag_lokasi'] = this.flagLokasi;
    data['flag_upload_foto'] = this.flagUploadFoto;
    data['id_company'] = this.idCompany;
    return data;
  }
}
