import 'dart:convert';

DataProductRespon dataProductResponFromJson(String str) => DataProductRespon.fromJson(json.decode(str));

String dataProductResponToJson(DataProductRespon data) => json.encode(data.toJson());

class DataProductRespon {
  bool? success;
  String? message;
  List<DataProduct>? data;

  DataProductRespon({this.success, this.message, this.data});

  DataProductRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <DataProduct>[];
      json['data'].forEach((v) {
        data!.add(new DataProduct.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataProduct {
  String? idProductM;
  String? idProductGroupM;
  String? kode;
  String? nama;
  int? harga;
  int? diskon;
  int? jmlProduk;
  int? totalHarga;

  DataProduct(
      {this.idProductM,
        this.idProductGroupM,
        this.kode,
        this.nama,
        this.harga,
        this.diskon,
        this.jmlProduk,
        this.totalHarga});

  DataProduct.fromJson(Map<String, dynamic> json) {
    idProductM = json['id_product_m'];
    idProductGroupM = json['id_product_group_m'];
    kode = json['kode'];
    nama = json['nama'];
    harga = json['harga'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_product_m'] = this.idProductM;
    data['id_product_group_m'] = this.idProductGroupM;
    data['kode'] = this.kode;
    data['nama'] = this.nama;
    data['harga'] = this.harga;
    return data;
  }
}
