import 'dart:convert';

DataAktivitasSalesRespon dataAktivitasSalesResponFromJson(String str) => DataAktivitasSalesRespon.fromJson(json.decode(str));

String dataAktivitasSalesResponToJson(DataAktivitasSalesRespon data) => json.encode(data.toJson());

class DataAktivitasSalesRespon {
  bool? success;
  String? message;
  List<DataAktivitasSales>? dataAktivitasSales;

  DataAktivitasSalesRespon(
      {this.success,
        this.message,
        this.dataAktivitasSales});

  DataAktivitasSalesRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_aktivitas_sales'] != null) {
      dataAktivitasSales = <DataAktivitasSales>[];
      json['data_aktivitas_sales'].forEach((v) {
        dataAktivitasSales!.add(new DataAktivitasSales.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataAktivitasSales != null) {
      data['data_aktivitas_sales'] =
          this.dataAktivitasSales!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataAktivitasSales {
  String? kategori;
  List<DataAS>? data;

  DataAktivitasSales({this.kategori, this.data});

  DataAktivitasSales.fromJson(Map<String, dynamic> json) {
    kategori = json['kategori'];
    if (json['data'] != null) {
      data = <DataAS>[];
      json['data'].forEach((v) {
        data!.add(new DataAS.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['kategori'] = this.kategori;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataAS {
  String? tabel;
  String? id;
  Status? status;
  String? idPipelineMain;
  String? idPipelineMainLog;
  String? idPelanggan;
  String? tahapanSebelum;
  String? tahapanSekarang;
  String? kategori;
  String? aktivitas;
  String? keterangan;
  String? ketMove;
  String? tanggal;
  String? waktu;
  String? userInput;
  String? userId;
  bool? buttonDetail;
  String? jam;
  bool? showStatus;

  DataAS(
      {this.tabel,
        this.id,
        this.status,
        this.idPipelineMain,
        this.idPipelineMainLog,
        this.idPelanggan,
        this.tahapanSebelum,
        this.tahapanSekarang,
        this.kategori,
        this.aktivitas,
        this.keterangan,
        this.ketMove,
        this.tanggal,
        this.waktu,
        this.userInput,
        this.userId,
        this.buttonDetail,
        this.jam,
        this.showStatus});

  DataAS.fromJson(Map<String, dynamic> json) {
    tabel = json['tabel'];
    id = json['id'];
    status = json['status'] != null ? new Status.fromJson(json['status']) : null;
    idPipelineMain = json['id_pipeline_main'];
    idPipelineMainLog = json['id_pipeline_main_log'];
    idPelanggan = json['id_pelanggan'];
    tahapanSebelum = json['tahapan_sebelum'];
    tahapanSekarang = json['tahapan_sekarang'];
    kategori = json['kategori'];
    aktivitas = json['aktivitas'];
    keterangan = json['keterangan'];
    ketMove = json['ket_move'];
    tanggal = json['tanggal'];
    waktu = json['waktu'];
    userInput = json['user_input'];
    userId = json['user_id'];
    buttonDetail = json['button_detail'];
    jam = json['jam'];
    showStatus = json['show_status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tabel'] = this.tabel;
    data['id'] = this.id;
    if (this.status != null) {
      data['status'] = this.status!.toJson();
    }
    data['id_pipeline_main'] = this.idPipelineMain;
    data['id_pipeline_main_log'] = this.idPipelineMainLog;
    data['id_pelanggan'] = this.idPelanggan;
    data['tahapan_sebelum'] = this.tahapanSebelum;
    data['tahapan_sekarang'] = this.tahapanSekarang;
    data['kategori'] = this.kategori;
    data['aktivitas'] = this.aktivitas;
    data['keterangan'] = this.keterangan;
    data['ket_move'] = this.ketMove;
    data['tanggal'] = this.tanggal;
    data['waktu'] = this.waktu;
    data['user_input'] = this.userInput;
    data['user_id'] = this.userId;
    data['button_detail'] = this.buttonDetail;
    data['jam'] = this.jam;
    data['show_status'] = this.showStatus;
    return data;
  }
}

class Status {
  String? status;
  String? value;
  String? color;
  String? fontColor;
  String? labelColor;
  String? labelFontColor;

  Status({this.status, this.value, this.color, this.fontColor, this.labelColor, this.labelFontColor});

  Status.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    value = json['value'];
    color = json['color'];
    fontColor = json['font_color'];
    labelColor = json['label_color'];
    labelFontColor = json['label_font_color'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['status'] = this.status;
    data['value'] = this.value;
    data['color'] = this.color;
    data['font_color'] = this.fontColor;
    data['label_color'] = this.labelColor;
    data['label_font_color'] = this.labelFontColor;
    return data;
  }
}




