import 'dart:convert';

PageTukarShiftModel pageTukarShiftModelFromJson(String str) => PageTukarShiftModel.fromJson(json.decode(str));

String pageTukarShiftModelToJson(PageTukarShiftModel data) => json.encode(data.toJson());

class PageTukarShiftModel {
  MenuTukarShift? menuTukarShift;

  PageTukarShiftModel({this.menuTukarShift});

  PageTukarShiftModel.fromJson(Map<String, dynamic> json) {
    menuTukarShift = json['menu_tukar_shift'] != null
        ? new MenuTukarShift.fromJson(json['menu_tukar_shift'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuTukarShift != null) {
      data['menu_tukar_shift'] = this.menuTukarShift!.toJson();
    }
    return data;
  }
}

class MenuTukarShift {
  String? title;
  String? tabJadwalSaya;
  String? tabJadwalTeman;
  String? tabJadwalKaryawan;
  String? tabPengajuanSaya;
  String? tabPengajuanTeman;
  String? tabPengajuanKaryawan;
  String? tabDetail;
  String? locale;
  Data? data;
  Button? button;

  MenuTukarShift(
      {this.title,
        this.tabJadwalSaya,
        this.tabJadwalTeman,
        this.tabJadwalKaryawan,
        this.tabPengajuanSaya,
        this.tabPengajuanTeman,
        this.tabPengajuanKaryawan,
        this.tabDetail,
        this.locale,
        this.data,
        this.button});

  MenuTukarShift.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    tabJadwalSaya = json['tab_jadwal_saya'];
    tabJadwalTeman = json['tab_jadwal_teman'];
    tabJadwalKaryawan = json['tab_jadwal_karyawan'];
    tabPengajuanSaya = json['tab_pengajuan_saya'];
    tabPengajuanTeman = json['tab_pengajuan_teman'];
    tabPengajuanKaryawan = json['tab_pengajuan_karyawan'];
    tabDetail = json['tab_detail'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['tab_jadwal_saya'] = this.tabJadwalSaya;
    data['tab_jadwal_teman'] = this.tabJadwalTeman;
    data['tab_jadwal_karyawan'] = this.tabJadwalKaryawan;
    data['tab_pengajuan_saya'] = this.tabPengajuanSaya;
    data['tab_pengajuan_teman'] = this.tabPengajuanTeman;
    data['tab_pengajuan_karyawan'] = this.tabPengajuanKaryawan;
    data['tab_detail'] = this.tabDetail;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    return data;
  }
}

class Data {
  String? header;
  String? tanggalPengajuan;
  String? nomor;
  String? approval;
  String? shiftAnda;
  String? shiftSaya;
  String? shiftTeman;
  String? pilihShift;
  String? cariShift;
  String? keterangan;
  String? ditukarDengan;
  String? pilihTeman;
  String? cariNama;
  String? messageBelumPilihShift;
  String? messageKeteranganEmpty;

  Data(
      {this.header,
        this.tanggalPengajuan,
        this.nomor,
        this.approval,
        this.shiftAnda,
        this.shiftSaya,
        this.shiftTeman,
        this.pilihShift,
        this.cariShift,
        this.keterangan,
        this.ditukarDengan,
        this.pilihTeman,
        this.cariNama,
        this.messageBelumPilihShift,
        this.messageKeteranganEmpty});

  Data.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    tanggalPengajuan = json['tanggal_pengajuan'];
    nomor = json['nomor'];
    approval = json['approval'];
    shiftAnda = json['shift_anda'];
    shiftSaya = json['shift_saya'];
    shiftTeman = json['shift_teman'];
    pilihShift = json['pilih_shift'];
    cariShift = json['cari_shift'];
    keterangan = json['keterangan'];
    ditukarDengan = json['ditukar_dengan'];
    pilihTeman = json['pilih_teman'];
    cariNama = json['cari_nama'];
    messageBelumPilihShift = json['message_belum_pilih_shift'];
    messageKeteranganEmpty = json['message_keterangan_empty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['tanggal_pengajuan'] = this.tanggalPengajuan;
    data['nomor'] = this.nomor;
    data['approval'] = this.approval;
    data['shift_anda'] = this.shiftAnda;
    data['shift_saya'] = this.shiftSaya;
    data['shift_teman'] = this.shiftTeman;
    data['pilih_shift'] = this.pilihShift;
    data['cari_shift'] = this.cariShift;
    data['keterangan'] = this.keterangan;
    data['ditukar_dengan'] = this.ditukarDengan;
    data['pilih_teman'] = this.pilihTeman;
    data['cari_nama'] = this.cariNama;
    data['message_belum_pilih_shift'] = this.messageBelumPilihShift;
    data['message_keterangan_empty'] = this.messageKeteranganEmpty;
    return data;
  }
}

class Button {
  String? btnBack;
  String? btnSubmit;
  String? btnCancel;
  String? btnNext;
  String? btnTolak;
  String? btnTerima;

  Button(
      {this.btnBack,
        this.btnSubmit,
        this.btnCancel,
        this.btnNext,
        this.btnTolak,
        this.btnTerima});

  Button.fromJson(Map<String, dynamic> json) {
    btnBack = json['btn_back'];
    btnSubmit = json['btn_submit'];
    btnCancel = json['btn_cancel'];
    btnNext = json['btn_next'];
    btnTolak = json['btn_tolak'];
    btnTerima = json['btn_terima'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btn_back'] = this.btnBack;
    data['btn_submit'] = this.btnSubmit;
    data['btn_cancel'] = this.btnCancel;
    data['btn_next'] = this.btnNext;
    data['btn_tolak'] = this.btnTolak;
    data['btn_terima'] = this.btnTerima;
    return data;
  }
}

