import 'dart:convert';

PageSlipGajiModel pageSlipGajiModelFromJson(String str) => PageSlipGajiModel.fromJson(json.decode(str));

String pageSlipGajiModelToJson(PageSlipGajiModel data) => json.encode(data.toJson());

class PageSlipGajiModel {
  MenuSlipGaji? menuSlipGaji;

  PageSlipGajiModel({this.menuSlipGaji});

  PageSlipGajiModel.fromJson(Map<String, dynamic> json) {
    menuSlipGaji = json['menu_slip_gaji'] != null
        ? new MenuSlipGaji.fromJson(json['menu_slip_gaji'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuSlipGaji != null) {
      data['menu_slip_gaji'] = this.menuSlipGaji!.toJson();
    }
    return data;
  }
}

class MenuSlipGaji {
  String? title;
  String? copyLink;
  String? linkTersalin;
  DialogPassword? dialogPassword;

  MenuSlipGaji(
      {this.title, this.copyLink, this.linkTersalin, this.dialogPassword});

  MenuSlipGaji.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    copyLink = json['copy_link'];
    linkTersalin = json['link_tersalin'];
    dialogPassword = json['dialog_password'] != null
        ? new DialogPassword.fromJson(json['dialog_password'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['copy_link'] = this.copyLink;
    data['link_tersalin'] = this.linkTersalin;
    if (this.dialogPassword != null) {
      data['dialog_password'] = this.dialogPassword!.toJson();
    }
    return data;
  }
}

class DialogPassword {
  String? password;
  String? btnClose;
  String? btnSubmit;

  DialogPassword({this.password, this.btnClose, this.btnSubmit});

  DialogPassword.fromJson(Map<String, dynamic> json) {
    password = json['password'];
    btnClose = json['btn_close'];
    btnSubmit = json['btn_submit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['password'] = this.password;
    data['btn_close'] = this.btnClose;
    data['btn_submit'] = this.btnSubmit;
    return data;
  }
}
