import 'dart:convert';

PageReimbursementModel pageReimbursementModelFromJson(String str) => PageReimbursementModel.fromJson(json.decode(str));

String pageReimbursementModelToJson(PageReimbursementModel data) => json.encode(data.toJson());

class PageReimbursementModel {
  MenuReimbursement? menuReimbursement;

  PageReimbursementModel({this.menuReimbursement});

  PageReimbursementModel.fromJson(Map<String, dynamic> json) {
    menuReimbursement = json['menu_reimbursement'] != null
        ? new MenuReimbursement.fromJson(json['menu_reimbursement'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuReimbursement != null) {
      data['menu_reimbursement'] = this.menuReimbursement!.toJson();
    }
    return data;
  }
}

class MenuReimbursement {
  String? title;
  String? addTitle;
  String? detailTitle;
  String? rekapTitle;
  String? tabDraf;
  String? tabPengajuan;
  String? tabPengajuanSaya;
  String? tabPengajuanKaryawan;
  String? tabApprovalAdmin;
  String? locale;
  Data? data;
  Message? message;
  Button? button;

  MenuReimbursement(
      {this.title,
        this.addTitle,
        this.detailTitle,
        this.rekapTitle,
        this.tabDraf,
        this.tabPengajuan,
        this.tabPengajuanSaya,
        this.tabPengajuanKaryawan,
        this.tabApprovalAdmin,
        this.locale,
        this.data,
        this.message,
        this.button});

  MenuReimbursement.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    addTitle = json['add_title'];
    detailTitle = json['detail_title'];
    rekapTitle = json['rekap_title'];
    tabDraf = json['tab_draf'];
    tabPengajuan = json['tab_pengajuan'];
    tabPengajuanSaya = json['tab_pengajuan_saya'];
    tabPengajuanKaryawan = json['tab_pengajuan_karyawan'];
    tabApprovalAdmin = json['tab_approval_admin'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['add_title'] = this.addTitle;
    data['detail_title'] = this.detailTitle;
    data['rekap_title'] = this.rekapTitle;
    data['tab_draf'] = this.tabDraf;
    data['tab_pengajuan'] = this.tabPengajuan;
    data['tab_pengajuan_saya'] = this.tabPengajuanSaya;
    data['tab_pengajuan_karyawan'] = this.tabPengajuanKaryawan;
    data['tab_approval_admin'] = this.tabApprovalAdmin;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    return data;
  }
}

class Data {
  String? jenis;
  String? nominal;
  String? tanggalNote;
  String? keterangan;
  String? totalPengajuan;
  String? idr;
  String? kegiatan;
  String? item;
  String? totalDisetujui;
  String? catatan;
  String? direvisi;
  String? ditolak;
  String? setujui;
  String? dibatalkan;
  String? nominalPlafon;
  String? nominalPengajuan;
  String? nominalDisetujui;
  String? catatanUntukAtasan;

  Data(
      {this.jenis,
        this.nominal,
        this.tanggalNote,
        this.keterangan,
        this.totalPengajuan,
        this.idr,
        this.kegiatan,
        this.item,
        this.totalDisetujui,
        this.catatan,
        this.direvisi,
        this.ditolak,
        this.setujui,
        this.dibatalkan,
        this.nominalPlafon,
        this.nominalPengajuan,
        this.nominalDisetujui,
        this.catatanUntukAtasan});

  Data.fromJson(Map<String, dynamic> json) {
    jenis = json['jenis'];
    nominal = json['nominal'];
    tanggalNote = json['tanggal_note'];
    keterangan = json['keterangan'];
    totalPengajuan = json['total_pengajuan'];
    idr = json['idr'];
    kegiatan = json['kegiatan'];
    item = json['item'];
    totalDisetujui = json['total_disetujui'];
    catatan = json['catatan'];
    direvisi = json['direvisi'];
    ditolak = json['ditolak'];
    setujui = json['setujui'];
    dibatalkan = json['dibatalkan'];
    nominalPlafon = json['nominal_plafon'];
    nominalPengajuan = json['nominal_pengajuan'];
    nominalDisetujui = json['nominal_disetujui'];
    catatanUntukAtasan = json['catatan_untuk_atasan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['jenis'] = this.jenis;
    data['nominal'] = this.nominal;
    data['tanggal_note'] = this.tanggalNote;
    data['keterangan'] = this.keterangan;
    data['total_pengajuan'] = this.totalPengajuan;
    data['idr'] = this.idr;
    data['kegiatan'] = this.kegiatan;
    data['item'] = this.item;
    data['total_disetujui'] = this.totalDisetujui;
    data['catatan'] = this.catatan;
    data['direvisi'] = this.direvisi;
    data['ditolak'] = this.ditolak;
    data['setujui'] = this.setujui;
    data['dibatalkan'] = this.dibatalkan;
    data['nominal_plafon'] = this.nominalPlafon;
    data['nominal_pengajuan'] = this.nominalPengajuan;
    data['nominal_disetujui'] = this.nominalDisetujui;
    data['catatan_untuk_atasan'] = this.catatanUntukAtasan;
    return data;
  }
}

class Message {
  String? emptyFoto;
  String? konfirmasi;

  Message({this.emptyFoto, this.konfirmasi});

  Message.fromJson(Map<String, dynamic> json) {
    emptyFoto = json['empty_foto'];
    konfirmasi = json['konfirmasi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['empty_foto'] = this.emptyFoto;
    data['konfirmasi'] = this.konfirmasi;
    return data;
  }
}

class Button {
  String? btnAmbilFoto;
  String? btnTambah;
  String? btnAjukan;
  String? btnEdit;
  String? btnHapus;
  String? btnCancel;
  String? btnSubmit;
  String? btnBatalkan;
  String? lakukanRevisi;
  String? onprogess;
  String? btnSetujui;
  String? btnRevisi;
  String? btnTolak;
  String? btnYa;
  String? btnTidak;
  String? btnClose;

  Button(
      {this.btnAmbilFoto,
        this.btnTambah,
        this.btnAjukan,
        this.btnEdit,
        this.btnHapus,
        this.btnCancel,
        this.btnSubmit,
        this.btnBatalkan,
        this.lakukanRevisi,
        this.onprogess,
        this.btnSetujui,
        this.btnRevisi,
        this.btnTolak,
        this.btnYa,
        this.btnTidak,
        this.btnClose});

  Button.fromJson(Map<String, dynamic> json) {
    btnAmbilFoto = json['btn_ambil_foto'];
    btnTambah = json['btn_tambah'];
    btnAjukan = json['btn_ajukan'];
    btnEdit = json['btn_edit'];
    btnHapus = json['btn_hapus'];
    btnCancel = json['btn_cancel'];
    btnSubmit = json['btn_submit'];
    btnBatalkan = json['btn_batalkan'];
    lakukanRevisi = json['lakukan_revisi'];
    onprogess = json['onprogess'];
    btnSetujui = json['btn_setujui'];
    btnRevisi = json['btn_revisi'];
    btnTolak = json['btn_tolak'];
    btnYa = json['btn_ya'];
    btnTidak = json['btn_tidak'];
    btnClose = json['btn_close'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btn_ambil_foto'] = this.btnAmbilFoto;
    data['btn_tambah'] = this.btnTambah;
    data['btn_ajukan'] = this.btnAjukan;
    data['btn_edit'] = this.btnEdit;
    data['btn_hapus'] = this.btnHapus;
    data['btn_cancel'] = this.btnCancel;
    data['btn_submit'] = this.btnSubmit;
    data['btn_batalkan'] = this.btnBatalkan;
    data['lakukan_revisi'] = this.lakukanRevisi;
    data['onprogess'] = this.onprogess;
    data['btn_setujui'] = this.btnSetujui;
    data['btn_revisi'] = this.btnRevisi;
    data['btn_tolak'] = this.btnTolak;
    data['btn_ya'] = this.btnYa;
    data['btn_tidak'] = this.btnTidak;
    data['btn_close'] = this.btnClose;
    return data;
  }
}
