import 'dart:convert';

PageParentTabModel pageParentTabModelFromJson(String str) => PageParentTabModel.fromJson(json.decode(str));

String pageParentTabModelToJson(PageParentTabModel data) => json.encode(data.toJson());

class PageParentTabModel {
  ParentTabData? parentTab;

  PageParentTabModel({this.parentTab});

  PageParentTabModel.fromJson(Map<String, dynamic> json) {
    parentTab = json['parent_tab'] != null
        ? new ParentTabData.fromJson(json['parent_tab'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.parentTab != null) {
      data['parent_tab'] = this.parentTab!.toJson();
    }
    return data;
  }
}

class ParentTabData {
  String? beranda;
  String? absensi;
  String? dataAbsensi;
  String? messageExit;
  String? textBtnCancel;
  String? textBtnSubmit;

  ParentTabData({this.beranda, this.absensi, this.dataAbsensi, this.messageExit, this.textBtnCancel, this.textBtnSubmit});

  ParentTabData.fromJson(Map<String, dynamic> json) {
    beranda = json['beranda'];
    absensi = json['absensi'];
    dataAbsensi = json['data_absensi'];
    messageExit = json['message_exit'];
    textBtnCancel = json['text_btn_cancel'];
    textBtnSubmit = json['text_btn_submit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['beranda'] = this.beranda;
    data['absensi'] = this.absensi;
    data['data_absensi'] = this.dataAbsensi;
    data['message_exit'] = this.messageExit;
    data['text_btn_cancel'] = this.textBtnCancel;
    data['text_btn_submit'] = this.textBtnSubmit;
    return data;
  }
}
