import 'dart:convert';

PageNotifikasiModel pageNotifikasiModelFromJson(String str) => PageNotifikasiModel.fromJson(json.decode(str));

String pageNotifikasiModelToJson(PageNotifikasiModel data) => json.encode(data.toJson());

class PageNotifikasiModel {
  Notifikasi? notifikasi;

  PageNotifikasiModel({this.notifikasi});

  PageNotifikasiModel.fromJson(Map<String, dynamic> json) {
    notifikasi = json['notifikasi'] != null
        ? new Notifikasi.fromJson(json['notifikasi'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.notifikasi != null) {
      data['notifikasi'] = this.notifikasi!.toJson();
    }
    return data;
  }
}

class Notifikasi {
  String? historyPengajuanData;
  String? pemberitahuan;

  Notifikasi({this.historyPengajuanData, this.pemberitahuan});

  Notifikasi.fromJson(Map<String, dynamic> json) {
    historyPengajuanData = json['history_pengajuan_data'];
    pemberitahuan = json['Pemberitahuan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['history_pengajuan_data'] = this.historyPengajuanData;
    data['Pemberitahuan'] = this.pemberitahuan;
    return data;
  }
}
