import 'dart:convert';

PageDataPendidikanModel pageDataPendidikanModelFromJson(String str) => PageDataPendidikanModel.fromJson(json.decode(str));

String pageDataPendidikanModelToJson(PageDataPendidikanModel data) => json.encode(data.toJson());

class PageDataPendidikanModel {
  MenuDataPendidikan? menuDataPendidikan;

  PageDataPendidikanModel({this.menuDataPendidikan});

  PageDataPendidikanModel.fromJson(Map<String, dynamic> json) {
    menuDataPendidikan = json['menu_data_pendidikan'] != null
        ? new MenuDataPendidikan.fromJson(json['menu_data_pendidikan'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataPendidikan != null) {
      data['menu_data_pendidikan'] = this.menuDataPendidikan!.toJson();
    }
    return data;
  }
}

class MenuDataPendidikan {
  String? title;
  String? editTitle;
  String? addTitle;
  String? terverifikasi;
  String? pengajuan;
  DataPendidikan? dataPendidikan;
  Button? button;
  Message? message;
  String? locale;

  MenuDataPendidikan(
      {this.title,
        this.editTitle,
        this.addTitle,
        this.terverifikasi,
        this.pengajuan,
        this.dataPendidikan,
        this.button,
        this.message,
        this.locale});

  MenuDataPendidikan.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    editTitle = json['edit_title'];
    addTitle = json['add_title'];
    terverifikasi = json['terverifikasi'];
    pengajuan = json['pengajuan'];
    dataPendidikan = json['data_pendidikan'] != null
        ? new DataPendidikan.fromJson(json['data_pendidikan'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['edit_title'] = this.editTitle;
    data['add_title'] = this.addTitle;
    data['terverifikasi'] = this.terverifikasi;
    data['pengajuan'] = this.pengajuan;
    if (this.dataPendidikan != null) {
      data['data_pendidikan'] = this.dataPendidikan!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class DataPendidikan {
  String? jenjangPendidikan;
  String? jurusan;
  String? namaSekolah;
  String? tahunMasuk;
  String? tahunLulus;
  String? lulusanAsal;
  String? gelar;
  String? lampiranIjasah;
  String? lampiranTranskrip;

  DataPendidikan(
      {this.jenjangPendidikan,
        this.jurusan,
        this.namaSekolah,
        this.tahunMasuk,
        this.tahunLulus,
        this.lulusanAsal,
        this.gelar,
        this.lampiranIjasah,
        this.lampiranTranskrip});

  DataPendidikan.fromJson(Map<String, dynamic> json) {
    jenjangPendidikan = json['jenjang_pendidikan'];
    jurusan = json['jurusan'];
    namaSekolah = json['nama_sekolah'];
    tahunMasuk = json['tahun_masuk'];
    tahunLulus = json['tahun_lulus'];
    lulusanAsal = json['lulusan_asal'];
    gelar = json['gelar'];
    lampiranIjasah = json['lampiran_ijasah'];
    lampiranTranskrip = json['lampiran_transkrip'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['jenjang_pendidikan'] = this.jenjangPendidikan;
    data['jurusan'] = this.jurusan;
    data['nama_sekolah'] = this.namaSekolah;
    data['tahun_masuk'] = this.tahunMasuk;
    data['tahun_lulus'] = this.tahunLulus;
    data['lulusan_asal'] = this.lulusanAsal;
    data['gelar'] = this.gelar;
    data['lampiran_ijasah'] = this.lampiranIjasah;
    data['lampiran_transkrip'] = this.lampiranTranskrip;
    return data;
  }
}

class Button {
  String? ubahData;
  String? hapusData;
  String? ajukanPerubahanData;
  String? ajukanData;
  String? catatanRevisi;
  String? btnTutup;
  String? btnBatal;
  String? btnYa;
  String? btnSend;

  Button(
      {this.ubahData,
        this.hapusData,
        this.ajukanPerubahanData,
        this.ajukanData,
        this.catatanRevisi,
        this.btnTutup,
        this.btnBatal,
        this.btnYa,
        this.btnSend});

  Button.fromJson(Map<String, dynamic> json) {
    ubahData = json['ubah_data'];
    hapusData = json['hapus_data'];
    ajukanPerubahanData = json['ajukan_perubahan_data'];
    ajukanData = json['ajukan_data'];
    catatanRevisi = json['catatan_revisi'];
    btnTutup = json['btn_tutup'];
    btnBatal = json['btn_batal'];
    btnYa = json['btn_ya'];
    btnSend = json['btn_send'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ubah_data'] = this.ubahData;
    data['hapus_data'] = this.hapusData;
    data['ajukan_perubahan_data'] = this.ajukanPerubahanData;
    data['ajukan_data'] = this.ajukanData;
    data['catatan_revisi'] = this.catatanRevisi;
    data['btn_tutup'] = this.btnTutup;
    data['btn_batal'] = this.btnBatal;
    data['btn_ya'] = this.btnYa;
    data['btn_send'] = this.btnSend;
    return data;
  }
}

class Message {
  String? hapusData;
  String? pengajuanHapus;
  String? jenjangPendidikanEmpty;
  String? namaSekolahEmpty;
  String? tahunMasuk;
  String? tahunLulus;
  String? lulusanAsal;

  Message(
      {this.hapusData,
        this.pengajuanHapus,
        this.jenjangPendidikanEmpty,
        this.namaSekolahEmpty,
        this.tahunMasuk,
        this.tahunLulus,
        this.lulusanAsal});

  Message.fromJson(Map<String, dynamic> json) {
    hapusData = json['hapus_data'];
    pengajuanHapus = json['pengajuan_hapus'];
    jenjangPendidikanEmpty = json['jenjang_pendidikan_empty'];
    namaSekolahEmpty = json['nama_sekolah_empty'];
    tahunMasuk = json['tahun_masuk'];
    tahunLulus = json['tahun_lulus'];
    lulusanAsal = json['lulusan_asal'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hapus_data'] = this.hapusData;
    data['pengajuan_hapus'] = this.pengajuanHapus;
    data['jenjang_pendidikan_empty'] = this.jenjangPendidikanEmpty;
    data['nama_sekolah_empty'] = this.namaSekolahEmpty;
    data['tahun_masuk'] = this.tahunMasuk;
    data['tahun_lulus'] = this.tahunLulus;
    data['lulusan_asal'] = this.lulusanAsal;
    return data;
  }
}
