import 'dart:convert';

PageDataKeluargaModel pageDataKeluargaModelFromJson(String str) => PageDataKeluargaModel.fromJson(json.decode(str));

String pageDataKeluargaModelToJson(PageDataKeluargaModel data) => json.encode(data.toJson());

class PageDataKeluargaModel {
  MenuDataKeluarga? menuDataKeluarga;

  PageDataKeluargaModel({this.menuDataKeluarga});

  PageDataKeluargaModel.fromJson(Map<String, dynamic> json) {
    menuDataKeluarga = json['menu_data_keluarga'] != null
        ? new MenuDataKeluarga.fromJson(json['menu_data_keluarga'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataKeluarga != null) {
      data['menu_data_keluarga'] = this.menuDataKeluarga!.toJson();
    }
    return data;
  }
}

class MenuDataKeluarga {
  String? title;
  String? editTitle;
  String? addTitle;
  String? terverifikasi;
  String? pengajuan;
  DataKeluarga? dataKeluarga;
  Button? button;
  Message? message;
  String? locale;

  MenuDataKeluarga(
      {this.title,
        this.editTitle,
        this.addTitle,
        this.terverifikasi,
        this.pengajuan,
        this.dataKeluarga,
        this.button,
        this.message,
        this.locale});

  MenuDataKeluarga.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    editTitle = json['edit_title'];
    addTitle = json['add_title'];
    terverifikasi = json['terverifikasi'];
    pengajuan = json['pengajuan'];
    dataKeluarga = json['data_keluarga'] != null
        ? new DataKeluarga.fromJson(json['data_keluarga'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['edit_title'] = this.editTitle;
    data['add_title'] = this.addTitle;
    data['terverifikasi'] = this.terverifikasi;
    data['pengajuan'] = this.pengajuan;
    if (this.dataKeluarga != null) {
      data['data_keluarga'] = this.dataKeluarga!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class DataKeluarga {
  String? hubKeluarga;
  String? nik;
  String? namaLengkap;
  String? tempatLahir;
  String? tanggalLahir;
  String? jenisKelamin;
  String? agama;
  String? pendidikanTerakhir;
  String? pekerjaan;
  String? statusPerkawinan;
  String? tanggalPerkawinan;
  String? telepon;
  String? noBpjsKes;
  String? status;

  DataKeluarga(
      {this.hubKeluarga,
        this.nik,
        this.namaLengkap,
        this.tempatLahir,
        this.tanggalLahir,
        this.jenisKelamin,
        this.agama,
        this.pendidikanTerakhir,
        this.pekerjaan,
        this.statusPerkawinan,
        this.tanggalPerkawinan,
        this.telepon,
        this.noBpjsKes,
        this.status});

  DataKeluarga.fromJson(Map<String, dynamic> json) {
    hubKeluarga = json['hubungan_keluarga'];
    nik = json['nik'];
    namaLengkap = json['nama_lengkap'];
    tempatLahir = json['tempat_lahir'];
    tanggalLahir = json['tanggal_lahir'];
    jenisKelamin = json['jenis_kelamin'];
    agama = json['agama'];
    pendidikanTerakhir = json['pendidikan_terakhir'];
    pekerjaan = json['pekerjaan'];
    statusPerkawinan = json['status_perkawinan'];
    tanggalPerkawinan = json['tanggal_perkawinan'];
    telepon = json['telepon'];
    noBpjsKes = json['no_bpjs_kes'];
    status = json['status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hubungan_keluarga'] = this.hubKeluarga;
    data['nik'] = this.nik;
    data['nama_lengkap'] = this.namaLengkap;
    data['tempat_lahir'] = this.tempatLahir;
    data['tanggal_lahir'] = this.tanggalLahir;
    data['jenis_kelamin'] = this.jenisKelamin;
    data['agama'] = this.agama;
    data['pendidikan_terakhir'] = this.pendidikanTerakhir;
    data['pekerjaan'] = this.pekerjaan;
    data['status_perkawinan'] = this.statusPerkawinan;
    data['tanggal_perkawinan'] = this.tanggalPerkawinan;
    data['telepon'] = this.telepon;
    data['no_bpjs_kes'] = this.noBpjsKes;
    data['status'] = this.status;
    return data;
  }
}

class Button {
  String? ubahData;
  String? hapusData;
  String? ajukanPerubahanData;
  String? ajukanData;
  String? catatanRevisi;
  String? btnTutup;
  String? btnBatal;
  String? btnYa;

  Button(
      {this.ubahData,
        this.hapusData,
        this.ajukanPerubahanData,
        this.ajukanData,
        this.catatanRevisi,
        this.btnTutup,
        this.btnBatal,
        this.btnYa});

  Button.fromJson(Map<String, dynamic> json) {
    ubahData = json['ubah_data'];
    hapusData = json['hapus_data'];
    ajukanPerubahanData = json['ajukan_perubahan_data'];
    ajukanData = json['ajukan_data'];
    catatanRevisi = json['catatan_revisi'];
    btnTutup = json['btn_tutup'];
    btnBatal = json['btn_batal'];
    btnYa = json['btn_ya'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ubah_data'] = this.ubahData;
    data['hapus_data'] = this.hapusData;
    data['ajukan_perubahan_data'] = this.ajukanPerubahanData;
    data['ajukan_data'] = this.ajukanData;
    data['catatan_revisi'] = this.catatanRevisi;
    data['btn_tutup'] = this.btnTutup;
    data['btn_batal'] = this.btnBatal;
    data['btn_ya'] = this.btnYa;
    return data;
  }
}

class Message {
  String? hapusData;
  String? pengajuanHapus;
  String? hubKeluargaEmpty;
  String? namaLengkapEmpty;
  String? tempatLahirEmpty;
  String? tanggalLahirEmpty;
  String? jenisKelaminEmpty;
  String? agamaEmpty;
  String? jenisPekerjaan;
  String? statusPerkawinan;
  String? status;
  String? pendidikanTerakhirEmpty;

  Message(
      {this.hapusData,
        this.pengajuanHapus,
        this.hubKeluargaEmpty,
        this.namaLengkapEmpty,
        this.tempatLahirEmpty,
        this.tanggalLahirEmpty,
        this.jenisKelaminEmpty,
        this.agamaEmpty,
        this.jenisPekerjaan,
        this.statusPerkawinan,
        this.status,
        this.pendidikanTerakhirEmpty});

  Message.fromJson(Map<String, dynamic> json) {
    hapusData = json['hapus_data'];
    pengajuanHapus = json['pengajuan_hapus'];
    hubKeluargaEmpty = json['hub_keluarga_empty'];
    namaLengkapEmpty = json['nama_lengkap_empty'];
    tempatLahirEmpty = json['tempat_lahir_empty'];
    tanggalLahirEmpty = json['tanggal_lahir_empty'];
    jenisKelaminEmpty = json['jenis_kelamin_empty'];
    agamaEmpty = json['agama_empty'];
    jenisPekerjaan = json['jenis_pekerjaan'];
    statusPerkawinan = json['status_perkawinan'];
    status = json['status'];
    pendidikanTerakhirEmpty = json['pendidikan_terakhir_empty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hapus_data'] = this.hapusData;
    data['pengajuan_hapus'] = this.pengajuanHapus;
    data['hub_keluarga_empty'] = this.hubKeluargaEmpty;
    data['nama_lengkap_empty'] = this.namaLengkapEmpty;
    data['tempat_lahir_empty'] = this.tempatLahirEmpty;
    data['tanggal_lahir_empty'] = this.tanggalLahirEmpty;
    data['jenis_kelamin_empty'] = this.jenisKelaminEmpty;
    data['agama_empty'] = this.agamaEmpty;
    data['jenis_pekerjaan'] = this.jenisPekerjaan;
    data['status_perkawinan'] = this.statusPerkawinan;
    data['status'] = this.status;
    data['pendidikan_terakhir_empty'] = this.pendidikanTerakhirEmpty;
    return data;
  }
}
