import 'dart:convert';

PageDataKelengkapanFileModel pageDataKelengkapanFileModelFromJson(String str) => PageDataKelengkapanFileModel.fromJson(json.decode(str));

String pageDataKelengkapanFileModelToJson(PageDataKelengkapanFileModel data) => json.encode(data.toJson());

class PageDataKelengkapanFileModel {
  MenuDataKelengkapanFile? menuDataKelengkapanFile;

  PageDataKelengkapanFileModel({this.menuDataKelengkapanFile});

  PageDataKelengkapanFileModel.fromJson(Map<String, dynamic> json) {
    menuDataKelengkapanFile = json['menu_data_kelengkapan_file'] != null
        ? new MenuDataKelengkapanFile.fromJson(
        json['menu_data_kelengkapan_file'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataKelengkapanFile != null) {
      data['menu_data_kelengkapan_file'] =
          this.menuDataKelengkapanFile!.toJson();
    }
    return data;
  }
}

class MenuDataKelengkapanFile {
  String? title;
  String? editTitle;
  String? addTitle;
  String? terverifikasi;
  String? pengajuan;
  DataKelengkapanFile? dataKelengkapanFile;
  Button? button;
  Message? message;
  String? locale;

  MenuDataKelengkapanFile(
      {this.title,
        this.editTitle,
        this.addTitle,
        this.terverifikasi,
        this.pengajuan,
        this.dataKelengkapanFile,
        this.button,
        this.message,
        this.locale});

  MenuDataKelengkapanFile.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    editTitle = json['edit_title'];
    addTitle = json['add_title'];
    terverifikasi = json['terverifikasi'];
    pengajuan = json['pengajuan'];
    dataKelengkapanFile = json['data_kelengkapan_file'] != null
        ? new DataKelengkapanFile.fromJson(json['data_kelengkapan_file'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['edit_title'] = this.editTitle;
    data['add_title'] = this.addTitle;
    data['terverifikasi'] = this.terverifikasi;
    data['pengajuan'] = this.pengajuan;
    if (this.dataKelengkapanFile != null) {
      data['data_kelengkapan_file'] = this.dataKelengkapanFile!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class DataKelengkapanFile {
  String? namaDokumen;
  String? lampiran;

  DataKelengkapanFile({this.namaDokumen, this.lampiran});

  DataKelengkapanFile.fromJson(Map<String, dynamic> json) {
    namaDokumen = json['nama_dokumen'];
    lampiran = json['lampiran'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nama_dokumen'] = this.namaDokumen;
    data['lampiran'] = this.lampiran;
    return data;
  }
}

class Button {
  String? ubahData;
  String? hapusData;
  String? ajukanPerubahanData;
  String? ajukanData;
  String? catatanRevisi;
  String? btnTutup;
  String? btnBatal;
  String? btnYa;
  String? btnSend;

  Button(
      {this.ubahData,
        this.hapusData,
        this.ajukanPerubahanData,
        this.ajukanData,
        this.catatanRevisi,
        this.btnTutup,
        this.btnBatal,
        this.btnYa,
        this.btnSend});

  Button.fromJson(Map<String, dynamic> json) {
    ubahData = json['ubah_data'];
    hapusData = json['hapus_data'];
    ajukanPerubahanData = json['ajukan_perubahan_data'];
    ajukanData = json['ajukan_data'];
    catatanRevisi = json['catatan_revisi'];
    btnTutup = json['btn_tutup'];
    btnBatal = json['btn_batal'];
    btnYa = json['btn_ya'];
    btnSend = json['btn_send'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ubah_data'] = this.ubahData;
    data['hapus_data'] = this.hapusData;
    data['ajukan_perubahan_data'] = this.ajukanPerubahanData;
    data['ajukan_data'] = this.ajukanData;
    data['catatan_revisi'] = this.catatanRevisi;
    data['btn_tutup'] = this.btnTutup;
    data['btn_batal'] = this.btnBatal;
    data['btn_ya'] = this.btnYa;
    data['btn_send'] = this.btnSend;
    return data;
  }
}

class Message {
  String? hapusData;
  String? pengajuanHapus;
  String? namaDokumenEmpty;
  String? lampiranFileEmpty;

  Message(
      {this.hapusData,
        this.pengajuanHapus,
        this.namaDokumenEmpty,
        this.lampiranFileEmpty});

  Message.fromJson(Map<String, dynamic> json) {
    hapusData = json['hapus_data'];
    pengajuanHapus = json['pengajuan_hapus'];
    namaDokumenEmpty = json['nama_dokumen_empty'];
    lampiranFileEmpty = json['lampiran_file_empty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hapus_data'] = this.hapusData;
    data['pengajuan_hapus'] = this.pengajuanHapus;
    data['nama_dokumen_empty'] = this.namaDokumenEmpty;
    data['lampiran_file_empty'] = this.lampiranFileEmpty;
    return data;
  }
}
