import 'dart:convert';

PageDataAbsensiModel pageDataAbsensiModelFromJson(String str) => PageDataAbsensiModel.fromJson(json.decode(str));

String pageDataAbsensiModelToJson(PageDataAbsensiModel data) => json.encode(data.toJson());

class PageDataAbsensiModel {
  MenuDataAbsensi? menuDataAbsensi;

  PageDataAbsensiModel({this.menuDataAbsensi});

  PageDataAbsensiModel.fromJson(Map<String, dynamic> json) {
    menuDataAbsensi = json['menu_data_absensi'] != null
        ? new MenuDataAbsensi.fromJson(json['menu_data_absensi'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataAbsensi != null) {
      data['menu_data_absensi'] = this.menuDataAbsensi!.toJson();
    }
    return data;
  }
}

class MenuDataAbsensi {
  String? title;
  String? tabSaya;
  String? tabKaryawan;
  Data? data;
  String? locale;

  MenuDataAbsensi({this.title, this.tabSaya, this.tabKaryawan, this.data});

  MenuDataAbsensi.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    locale = json['locale'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    data['locale'] = this.locale;
    return data;
  }
}

class Data {
  String? namaKaryawan;
  String? masuk;
  String? pulang;

  Data({this.namaKaryawan, this.masuk, this.pulang});

  Data.fromJson(Map<String, dynamic> json) {
    namaKaryawan = json['nama_karyawan'];
    masuk = json['masuk'];
    pulang = json['pulang'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nama_karyawan'] = this.namaKaryawan;
    data['masuk'] = this.masuk;
    data['pulang'] = this.pulang;
    return data;
  }
}

