import 'dart:convert';

PageButtonModel pageButtonModelFromJson(String str) => PageButtonModel.fromJson(json.decode(str));

String pageButtonModelToJson(PageButtonModel data) => json.encode(data.toJson());

class PageButtonModel {
  Button? button;

  PageButtonModel({this.button});

  PageButtonModel.fromJson(Map<String, dynamic> json) {
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    return data;
  }
}

class Button {
  String? btnTUTUP;
  String? btnTutup;
  String? btnPeringatan;
  String? btnMasuk;

  Button({this.btnTUTUP, this.btnTutup, this.btnPeringatan, this.btnMasuk});

  Button.fromJson(Map<String, dynamic> json) {
    btnTUTUP = json['btnTUTUP'];
    btnTutup = json['btnTutup'];
    btnPeringatan = json['btnPeringatan'];
    btnMasuk = json['btnMasuk'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btnTUTUP'] = this.btnTUTUP;
    data['btnTutup'] = this.btnTutup;
    data['btnPeringatan'] = this.btnPeringatan;
    data['btnMasuk'] = this.btnMasuk;
    return data;
  }
}
