// To parse this JSON data, do
//
//     final dataPengajuanKpiTeam = dataPengajuanKpiTeamFromJson(jsonString);

import 'dart:convert';

DataPengajuanKpiTeamRespon dataPengajuanKpiTeamFromJson(String str) =>
    DataPengajuanKpiTeamRespon.fromJson(json.decode(str));

String dataPengajuanKpiTeamToJson(DataPengajuanKpiTeamRespon data) =>
    json.encode(data.toJson());

class DataPengajuanKpiTeamRespon {
  DataPengajuanKpiTeamRespon({
    this.success,
    this.message,
    this.data,
  });

  factory DataPengajuanKpiTeamRespon.fromJson(Map<String, dynamic> json) =>
      DataPengajuanKpiTeamRespon(
        success: json["success"],
        message: json["message"],
        data: json['data'] == null
            ? null
            : List<DataPengajuan>.from(
                json["data"].map((x) => DataPengajuan.fromJson(x))),
      );

  List<DataPengajuan>? data;
  String? message;
  bool? success;

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataPengajuan {
  DataPengajuan({
    this.idObjectM,
    this.nmObject,
    this.noUrut,
    this.idCompany,
    this.ignorePointer,
    this.ketPeriode,
    this.userInput,
    this.tglInput,
    this.userUpdate,
    this.tglUpdate,
    this.listItem,
  });

  factory DataPengajuan.fromJson(Map<String, dynamic> json) => DataPengajuan(
        idObjectM: json["id_object_m"],
        nmObject: json["nm_object"],
        noUrut: json["no_urut"],
        idCompany: json["id_company"],
        ignorePointer: json["ignore_pointer"],
        ketPeriode: json["ket_periode"],
        userInput: json["user_input"],
        tglInput: json["tgl_input"],
        userUpdate: json["user_update"],
        tglUpdate: json["tgl_update"],
        listItem: json['list_item'] == null
            ? null
            : List<ListItem>.from(
                json["list_item"].map((x) => ListItem.fromJson(x))),
      );

  String? idCompany;
  String? idObjectM;
  List<ListItem>? listItem;
  String? nmObject;
  int? noUrut;
  bool? ignorePointer;
  String? ketPeriode;
  String? tglInput;
  String? tglUpdate;
  String? userInput;
  String? userUpdate;

  Map<String, dynamic> toJson() => {
        "id_object_m": idObjectM,
        "nm_object": nmObject,
        "no_urut": noUrut,
        "id_company": idCompany,
        "ignore_pointer": ignorePointer,
        "ket_periode": ketPeriode,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
        "list_item": List<dynamic>.from(listItem!.map((x) => x.toJson())),
      };
}

class ListItem {
  ListItem({
    this.idPiTrx,
    this.idKaryawan,
    this.tahun,
    this.bulan,
    this.idObject,
    this.nmObject,
    this.noUrutObject,
    this.nmIndikator,
    this.target,
    this.bobot,
    this.poin1,
    this.poin2,
    this.poin3,
    this.poin4,
    this.poin5,
    this.noUrutIndikator,
    this.actualPoin,
    this.actualBukti,
    this.actualPoinApproval,
    this.idCompany,
    this.userInput,
    this.tglInput,
    this.userUpdate,
    this.tglUpdate,
  });

  factory ListItem.fromJson(Map<String, dynamic> json) => ListItem(
        idPiTrx: json['id_pi_trx'],
        idKaryawan: json["id_karyawan"],
        tahun: json["tahun"],
        bulan: json["bulan"],
        idObject: json["id_object"],
        nmObject: json["nm_object"],
        noUrutObject: json["no_urut_object"],
        nmIndikator: json["nm_aspek_kinerja"],
        target: json["target"],
        bobot: json["bobot"],
        poin1: json["poin_1"],
        poin2: json["poin_2"],
        poin3: json["poin_3"],
        poin4: json["poin_4"],
        poin5: json["poin_5"],
        noUrutIndikator: json["no_urut_indikator"],
        actualPoin: json["actual_poin"],
        actualBukti: json["actual_bukti"],
        actualPoinApproval: json["actual_poin_approval"],
        idCompany: json["id_company"],
        userInput: json["user_input"],
        tglInput: json["tgl_input"],
        userUpdate: json["user_update"],
        tglUpdate: json["tgl_update"],
      );
  String? idPiTrx;
  String? actualBukti;
  int? actualPoin;
  int? actualPoinApproval;
  int? bobot;
  int? bulan;
  String? idCompany;
  String? idKaryawan;
  String? idObject;
  String? nmIndikator;
  String? nmObject;
  int? noUrutIndikator;
  int? noUrutObject;
  String? poin1;
  String? poin2;
  String? poin3;
  String? poin4;
  String? poin5;
  int? tahun;
  String? target;
  String? tglInput;
  String? tglUpdate;
  String? userInput;
  String? userUpdate;

  Map<String, dynamic> toJson() => {
        "id_pi_trx": idPiTrx,
        "id_karyawan": idKaryawan,
        "tahun": tahun,
        "bulan": bulan,
        "id_object": idObject,
        "nm_object": nmObject,
        "no_urut_object": noUrutObject,
        "nm_aspek_kinerja": nmIndikator,
        "target": target,
        "bobot": bobot,
        "poin_1": poin1,
        "poin_2": poin2,
        "poin_3": poin3,
        "poin_4": poin4,
        "poin_5": poin5,
        "no_urut_indikator": noUrutIndikator,
        "actual_poin": actualPoin,
        "actual_bukti": actualBukti,
        "actual_poin_approval": actualPoinApproval,
        "id_company": idCompany,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
      };
}

class ModelPengajuanPerformanceIndikator {
  String? idPiTrx;
  String? karyawan;
  String? idCompany;
  int? bulan;
  int? tahun;
  String? idObject;
  String? nmObject;
  int? noUrutObject;
  String? nmIndikator;
  String? target;
  String? bobot;
  String? poin1;
  String? poin2;
  String? poin3;
  String? poin4;
  String? poin5;

  ModelPengajuanPerformanceIndikator(
      {this.idPiTrx,
      this.karyawan,
      this.idCompany,
      this.bulan,
      this.tahun,
      this.idObject,
      this.nmObject,
      this.noUrutObject,
      this.nmIndikator,
      this.bobot,
      this.target,
      this.poin1,
      this.poin2,
      this.poin3,
      this.poin4,
      this.poin5});
}

class ParsingModelKaryawan {
  String? karyawan;
  String? id_karyawan;
  String? id_company;
  int? bulan;
  int? tahun;

  ParsingModelKaryawan(
      {this.karyawan,
      this.id_karyawan,
      this.id_company,
      this.bulan,
      this.tahun});
}
