import 'dart:convert';

import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';

DataEditDataDiriRespon dataEditDataDiriResponFromJson(String str) => DataEditDataDiriRespon.fromJson(json.decode(str));

String dataEditDataDiriResponToJson(DataEditDataDiriRespon data) => json.encode(data.toJson());

class DataEditDataDiriRespon {
  bool? success;
  String? message;
  DataDatadiriEdit? dataDatadiriEdit;

  DataEditDataDiriRespon({this.success, this.message, this.dataDatadiriEdit});

  DataEditDataDiriRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataDatadiriEdit = json['data_datadiri'] != null
        ? new DataDatadiriEdit.fromJson(json['data_datadiri'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatadiriEdit != null) {
      data['data_datadiri'] = this.dataDatadiriEdit!.toJson();
    }
    return data;
  }
}

class DataDatadiriEdit {
  String? nik;
  String? namaLengkap;
  JenisData? pendidikanTerakhir;
  String? gelarDepan;
  String? gelarBelakang;
  JenisData? jenisKelamin;
  JenisData? golonganDarah;
  String? tempatLahir;
  String? tglLahir;
  String? telepon;
  String? email;
  JenisData? agama;
  JenisData? provinsi;
  JenisData? kabupaten;
  JenisData? kecamatan;
  JenisData? kelurahan;
  String? rt;
  String? rw;
  String? alamatDomisili;
  String? kodePos;
  String? noKtp;
  String? noBpjsKes;
  String? noBpjsTk;

  DataDatadiriEdit(
      {this.nik,
        this.namaLengkap,
        this.pendidikanTerakhir,
        this.gelarDepan,
        this.gelarBelakang,
        this.jenisKelamin,
        this.golonganDarah,
        this.tempatLahir,
        this.tglLahir,
        this.telepon,
        this.email,
        this.agama,
        this.provinsi,
        this.kabupaten,
        this.kecamatan,
        this.kelurahan,
        this.rt,
        this.rw,
        this.alamatDomisili,
        this.kodePos,
        this.noKtp,
        this.noBpjsKes,
        this.noBpjsTk});

  DataDatadiriEdit.fromJson(Map<String, dynamic> json) {
    nik = json['nik'];
    namaLengkap = json['nama_lengkap'];
    pendidikanTerakhir = json['pendidikan_terakhir'] != null
        ? new JenisData.fromJson(json['pendidikan_terakhir'])
        : null;
    gelarDepan = json['gelar_depan'];
    gelarBelakang = json['gelar_belakang'];
    jenisKelamin = json['jenis_kelamin'] != null
        ? new JenisData.fromJson(json['jenis_kelamin'])
        : null;
    golonganDarah = json['golongan_darah'] != null
        ? new JenisData.fromJson(json['golongan_darah'])
        : null;
    tempatLahir = json['tempat_lahir'];
    tglLahir = json['tgl_lahir'];
    telepon = json['telepon'];
    email = json['email'];
    agama = json['agama'] != null
        ? new JenisData.fromJson(json['agama'])
        : null;
    provinsi = json['provinsi'] != null
        ? new JenisData.fromJson(json['provinsi'])
        : null;
    kabupaten = json['kabupaten'] != null
        ? new JenisData.fromJson(json['kabupaten'])
        : null;
    kecamatan = json['kecamatan'] != null
        ? new JenisData.fromJson(json['kecamatan'])
        : null;
    kelurahan = json['kelurahan'] != null
        ? new JenisData.fromJson(json['kelurahan'])
        : null;
    rt = json['rt'];
    rw = json['rw'];
    alamatDomisili = json['alamat_domisili'];
    kodePos = json['kode_pos'];
    noKtp = json['no_ktp'];
    noBpjsKes = json['no_bpjs_kes'];
    noBpjsTk = json['no_bpjs_tk'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nik'] = this.nik;
    data['nama_lengkap'] = this.namaLengkap;
    if (this.pendidikanTerakhir != null) {
      data['pendidikan_terakhir'] = this.pendidikanTerakhir!.toJson();
    }
    data['gelar_depan'] = this.gelarDepan;
    data['gelar_belakang'] = this.gelarBelakang;
    if (this.jenisKelamin != null) {
      data['jenis_kelamin'] = this.jenisKelamin!.toJson();
    }
    if (this.golonganDarah != null) {
      data['golongan_darah'] = this.golonganDarah!.toJson();
    }
    data['tempat_lahir'] = this.tempatLahir;
    data['tgl_lahir'] = this.tglLahir;
    data['telepon'] = this.telepon;
    data['email'] = this.email;
    if (this.agama != null) {
      data['agama'] = this.agama!.toJson();
    }
    if (this.provinsi != null) {
      data['provinsi'] = this.provinsi!.toJson();
    }
    if (this.kabupaten != null) {
      data['kabupaten'] = this.kabupaten!.toJson();
    }
    if (this.kecamatan != null) {
      data['kecamatan'] = this.kecamatan!.toJson();
    }
    if (this.kelurahan != null) {
      data['kelurahan'] = this.kelurahan!.toJson();
    }
    data['rt'] = this.rt;
    data['rw'] = this.rw;
    data['alamat_domisili'] = this.alamatDomisili;
    data['kode_pos'] = this.kodePos;
    data['no_ktp'] = this.noKtp;
    data['no_bpjs_kes'] = this.noBpjsKes;
    data['no_bpjs_tk'] = this.noBpjsTk;
    return data;
  }
}

