import 'dart:convert';

DataDataDiriRespon dataDataDiriResponFromJson(String str) => DataDataDiriRespon.fromJson(json.decode(str));

String DataDataDiriResponToJson(DataDataDiriRespon data) => json.encode(data.toJson());

class DataDataDiriRespon {
  bool? success;
  String? message;
  DataDatadiri? dataDatadiri;

  DataDataDiriRespon({this.success, this.message, this.dataDatadiri});

  DataDataDiriRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataDatadiri = json['data_datadiri'] != null
        ? new DataDatadiri.fromJson(json['data_datadiri'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatadiri != null) {
      data['data_datadiri'] = this.dataDatadiri!.toJson();
    }
    return data;
  }
}

class DataDatadiri {
  String? nik;
  String? namaLengkap;
  String? pendidikanTerakhir;
  String? gelarDepan;
  String? gelarBelakang;
  String? jenisKelamin;
  String? golonganDarah;
  String? tempatLahir;
  String? tglLahir;
  String? telepon;
  String? email;
  String? agama;
  String? namaProvinsi;
  String? namaKabupaten;
  String? namaKecamatan;
  String? namaKelurahan;
  String? rt;
  String? rw;
  String? alamatDomisili;
  String? kodePos;
  String? noKtp;
  String? noBpjsKes;
  String? noBpjsTk;
  String? noAsuransi;
  String? statusPengajuan;
  String? colorStatusPengajuan;
  bool? buttonRevisi;
  String? ketRevisi;

  DataDatadiri(
      {this.nik,
        this.namaLengkap,
        this.pendidikanTerakhir,
        this.gelarDepan,
        this.gelarBelakang,
        this.jenisKelamin,
        this.golonganDarah,
        this.tempatLahir,
        this.tglLahir,
        this.telepon,
        this.email,
        this.agama,
        this.namaProvinsi,
        this.namaKabupaten,
        this.namaKecamatan,
        this.namaKelurahan,
        this.rt,
        this.rw,
        this.alamatDomisili,
        this.kodePos,
        this.noKtp,
        this.noBpjsKes,
        this.noBpjsTk,
        this.noAsuransi,
        this.statusPengajuan,
        this.colorStatusPengajuan,
        this.buttonRevisi,
        this.ketRevisi});

  DataDatadiri.fromJson(Map<String, dynamic> json) {
    nik = json['nik'];
    namaLengkap = json['nama_lengkap'];
    pendidikanTerakhir = json['pendidikan_terakhir'];
    gelarDepan = json['gelar_depan'];
    gelarBelakang = json['gelar_belakang'];
    jenisKelamin = json['jenis_kelamin'];
    golonganDarah = json['golongan_darah'];
    tempatLahir = json['tempat_lahir'];
    tglLahir = json['tgl_lahir'];
    telepon = json['telepon'];
    email = json['email'];
    agama = json['agama'];
    namaProvinsi = json['nama_provinsi'];
    namaKabupaten = json['nama_kabupaten'];
    namaKecamatan = json['nama_kecamatan'];
    namaKelurahan = json['nama_kelurahan'];
    rt = json['rt'];
    rw = json['rw'];
    alamatDomisili = json['alamat_domisili'];
    kodePos = json['kode_pos'];
    noKtp = json['no_ktp'];
    noBpjsKes = json['no_bpjs_kes'];
    noBpjsTk = json['no_bpjs_tk'];
    noAsuransi = json['no_asuransi'];
    statusPengajuan = json['status_pengajuan'];
    colorStatusPengajuan = json['color_status_pengajuan'];
    buttonRevisi = json['button_revisi'];
    ketRevisi = json['ket_revisi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nik'] = this.nik;
    data['nama_lengkap'] = this.namaLengkap;
    data['pendidikan_terakhir'] = this.pendidikanTerakhir;
    data['gelar_depan'] = this.gelarDepan;
    data['gelar_belakang'] = this.gelarBelakang;
    data['jenis_kelamin'] = this.jenisKelamin;
    data['golongan_darah'] = this.golonganDarah;
    data['tempat_lahir'] = this.tempatLahir;
    data['tgl_lahir'] = this.tglLahir;
    data['telepon'] = this.telepon;
    data['email'] = this.email;
    data['agama'] = this.agama;
    data['nama_provinsi'] = this.namaProvinsi;
    data['nama_kabupaten'] = this.namaKabupaten;
    data['nama_kecamatan'] = this.namaKecamatan;
    data['nama_kelurahan'] = this.namaKelurahan;
    data['rt'] = this.rt;
    data['rw'] = this.rw;
    data['alamat_domisili'] = this.alamatDomisili;
    data['kode_pos'] = this.kodePos;
    data['no_ktp'] = this.noKtp;
    data['no_bpjs_kes'] = this.noBpjsKes;
    data['no_bpjs_tk'] = this.noBpjsTk;
    data['no_asuransi'] = this.noAsuransi;
    data['status_pengajuan'] = this.statusPengajuan;
    data['color_status_pengajuan'] = this.colorStatusPengajuan;
    data['button_revisi'] = this.buttonRevisi;
    data['ket_revisi'] = this.ketRevisi;
    return data;
  }
}
