import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLaporanKinerja.dart';
import 'package:absenkuv3/Repository/Service/aktivitasApi.dart';
import 'package:absenkuv3/Repository/Service/klienApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class LaporanKinerjaKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListLaporanKinerjaKlienEvent extends LaporanKinerjaKlienEvent {
  ModelFilter? modelFilter;
  getListLaporanKinerjaKlienEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class loadMoreEvent extends LaporanKinerjaKlienEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class LaporanKinerjaKlienState {
  List<DataLaporanKinerja>? data;
  DataLaporanKinerja? dataLaporanKinerja;
}

class getListLapoanKinerjaKlienSuccessState extends LaporanKinerjaKlienState {
  getListLapoanKinerjaKlienSuccessState(
      LaporanKinerjaKlienEvent _event, List<DataLaporanKinerja>? _data) {
    data = _data;
  }
}

class LaporanKinerjaKlienProgressState extends LaporanKinerjaKlienState {}

class LoadMoreProgressState extends LaporanKinerjaKlienState {
  LoadMoreProgressState(List<DataLaporanKinerja>? _data) {
    data = _data;
  }
}

class LaporanKinerjaKlienErrorState extends LaporanKinerjaKlienState {}

class LaporanKinerjaKlienBloc
    extends Bloc<LaporanKinerjaKlienEvent, LaporanKinerjaKlienState> {
  LaporanKinerjaKlienState? initialState;
  List<DataLaporanKinerja>? listLaporanKinerja;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  LaporanKinerjaKlienBloc(LaporanKinerjaKlienState initialState)
      : super(initialState);

  @override
  Stream<LaporanKinerjaKlienState> mapEventToState(
      LaporanKinerjaKlienEvent event) async* {
    if (event is getListLaporanKinerjaKlienEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield LaporanKinerjaKlienProgressState();
      LaporanKinerjaRespon laporanKinerjaRespon =
          await KlienApi().getDataLaporanKinerja(offset, modelFilter);
      if (laporanKinerjaRespon.success!) {
        listLaporanKinerja = laporanKinerjaRespon.data;
        yield getListLapoanKinerjaKlienSuccessState(event, listLaporanKinerja);
      } else
        yield LaporanKinerjaKlienErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listLaporanKinerja);
        LaporanKinerjaRespon laporanKinerjaRespon =
            await KlienApi().getDataLaporanKinerja(offset, modelFilter);
        if (laporanKinerjaRespon.success!) {
          listLaporanKinerja!.addAll(laporanKinerjaRespon.data!);
        }
        yield getListLapoanKinerjaKlienSuccessState(event, listLaporanKinerja);
      }
    }
  }
}
