import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/klienApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class LaporanAbsensiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListLaporanAbsensiKlienEvent extends LaporanAbsensiKlienEvent {
  ModelFilter? modelFilterDataAbsensi;
  getListLaporanAbsensiKlienEvent(
      BuildContext _context, this.modelFilterDataAbsensi) {
    context = _context;
  }
}

class loadMoreEvent extends LaporanAbsensiKlienEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class LaporanAbsensiKlienState {
  List<DataRekapAbsensi>? data;
  DataIzin? dataDetail;
}

class getListLaporanAbsensiKlienSuccessState extends LaporanAbsensiKlienState {
  getListLaporanAbsensiKlienSuccessState(
      LaporanAbsensiKlienEvent _event, List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class parseDataLaporanAbsensiKlienState extends LaporanAbsensiKlienState {
  parseDataLaporanAbsensiKlienState(DataIzin _dataDetail) {
    dataDetail = _dataDetail;
  }
}

class LaporanAbsensiKlienProgressState extends LaporanAbsensiKlienState {}

class LoadMoreProgressState extends LaporanAbsensiKlienState {
  LoadMoreProgressState(List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class DataAbsensiPegawaiErrorState extends LaporanAbsensiKlienState {}

class LaporanAbsensiKlienBloc
    extends Bloc<LaporanAbsensiKlienEvent, LaporanAbsensiKlienState> {
  LaporanAbsensiKlienState? initialState;
  List<DataRekapAbsensi>? listAbsensi;
  ModelFilter? modelFilterDataAbsensi;
  int offset = 0;
  int limit = ServerInfo.limit;

  LaporanAbsensiKlienBloc(LaporanAbsensiKlienState initialState)
      : super(initialState);

  @override
  Stream<LaporanAbsensiKlienState> mapEventToState(
      LaporanAbsensiKlienEvent event) async* {
    if (event is getListLaporanAbsensiKlienEvent) {
      offset = 0;
      yield LaporanAbsensiKlienProgressState();
      modelFilterDataAbsensi = event.modelFilterDataAbsensi;
      RekapAbsensiRespon absensiRespon = await KlienApi()
          .getLaporanAbsensiKlien(modelFilterDataAbsensi, offset);
      if (absensiRespon.success!) {
        listAbsensi = absensiRespon.data;
        yield getListLaporanAbsensiKlienSuccessState(event, listAbsensi);
      } else
        yield DataAbsensiPegawaiErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAbsensi);
        RekapAbsensiRespon absensiRespon = await KlienApi()
            .getLaporanAbsensiKlien(modelFilterDataAbsensi, offset);
        if (absensiRespon.success!) {
          listAbsensi!.addAll(absensiRespon.data!);
        }
        yield getListLaporanAbsensiKlienSuccessState(event, listAbsensi);
      }
    }
  }
}
