import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapSakitEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapSakitEvent extends SummaryRekapSakitEvent {
  ModelFilter? modelFilter;
  getSummaryRekapSakitEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapSakitState {
  DataSummary? data;
}

class getSummaryRekapSakitSuccessState extends SummaryRekapSakitState {
  getSummaryRekapSakitSuccessState(
      SummaryRekapSakitEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressRekapSakitState extends SummaryRekapSakitState {}

class SummaryErrorState extends SummaryRekapSakitState {}

class SummaryRekapSakitBloc
    extends Bloc<SummaryRekapSakitEvent, SummaryRekapSakitState> {
  SummaryRekapSakitState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapSakitBloc(SummaryRekapSakitState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapSakitState> mapEventToState(
      SummaryRekapSakitEvent event) async* {
    if (event is getSummaryRekapSakitEvent) {
      yield SummaryProgressRekapSakitState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/sakit');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapSakitSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
