import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapLemburEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapLemburEvent extends SummaryRekapLemburEvent {
  ModelFilter? modelFilter;
  getSummaryRekapLemburEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapLemburState {
  DataSummary? data;
}

class getSummaryRekapLemburSuccessState extends SummaryRekapLemburState {
  getSummaryRekapLemburSuccessState(
      SummaryRekapLemburEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressLemburState extends SummaryRekapLemburState {}

class SummaryErrorState extends SummaryRekapLemburState {}

class SummaryRekapLemburBloc
    extends Bloc<SummaryRekapLemburEvent, SummaryRekapLemburState> {
  SummaryRekapLemburState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapLemburBloc(SummaryRekapLemburState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapLemburState> mapEventToState(
      SummaryRekapLemburEvent event) async* {
    if (event is getSummaryRekapLemburEvent) {
      yield SummaryProgressLemburState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/lembur');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapLemburSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
