import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryEvent extends SummaryEvent {
  ModelFilter? modelFilter;
  getSummaryEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}
class getSummaryNullEvent extends SummaryEvent {
  getSummaryNullEvent(BuildContext _context) {
    context = _context;
  }
}

class GetDataSummaryDashboardEvent extends SummaryEvent {
  GetDataSummaryDashboardEvent(BuildContext _context) {
    context = _context;
  }
}

abstract class SummaryState {
  DataSummary? data;
}

class getSummarySuccessState extends SummaryState {
  getSummarySuccessState(SummaryEvent _event, DataSummary? _data) {
    data = _data;
  }
}
class getSummarySuccessNullState extends SummaryState {
  getSummarySuccessNullState() {
  }
}

class getSummaryDashboardSuccessState extends SummaryState {
  getSummaryDashboardSuccessState(SummaryEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressState extends SummaryState {}

class LoadMoreProgressState extends SummaryState {
  LoadMoreProgressState(DataSummary _data) {
    data = _data;
  }
}

class SummaryErrorState extends SummaryState {}

class SummaryBloc extends Bloc<SummaryEvent, SummaryState> {
  SummaryState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryBloc(SummaryState initialState) : super(initialState);

  @override
  Stream<SummaryState> mapEventToState(SummaryEvent event) async* {
    // TODO: implement mapEventToState
    if (event is getSummaryEvent) {
      yield SummaryProgressState();
      modelFilter = event.modelFilter;
      /*yield SummaryProgressState();*/
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummary(modelFilter);
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummarySuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    } else if (event is GetDataSummaryDashboardEvent) {
      yield SummaryProgressState();
      SummaryRespon summaryRespon =
          await DashboardApi().getDataSummaryDashboard();
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryDashboardSuccessState(event, listSummary);
      } else {
        yield SummaryErrorState();
      }
    }else if(event is getSummaryNullEvent){
      yield getSummarySuccessNullState();
    }
  }
}
