import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/sosApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/progress_dialog.dart';

abstract class SosEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListSosEvent extends SosEvent {
  ModelFilter? modelFilter;
  getListSosEvent(BuildContext? _context, this.modelFilter) {
    context = _context;
  }
}
class getListSosKlienEvent extends SosEvent {
  ModelFilter? modelFilter;
  getListSosKlienEvent(BuildContext? _context, this.modelFilter) {
    context = _context;
  }
}

class pengajuanSos extends SosEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GlobalKey<FormState> formKey;
  ModelPengajuanSos modelSos;
  pengajuanSos(this.modelSos, this.context, this.scaffoldKey, this.formKey);
}

class loadMoreEvent extends SosEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}
class loadMoreKlienEvent extends SosEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class SosState {
  List<DataSo>? data;
}

class LoadMoreProgressState extends SosState {
  LoadMoreProgressState(List<DataSo>? _data) {
    data = _data;
  }
}

class getListSosSuccessState extends SosState {
  getListSosSuccessState(SosEvent _event, List<DataSo>? _data) {
    data = _data;
  }
}

class SosProgressState extends SosState {}

class SosErrorState extends SosState {}

class SosBloc extends Bloc<SosEvent, SosState> {
  SosState? initialState;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;
  List<DataSo>? listSos;
  SosBloc(SosState initialState) : super(initialState);
  @override
  Stream<SosState> mapEventToState(SosEvent event) async* {
    if (event is pengajuanSos) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SosApi().pengajuanSos(event.modelSos);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
      }
    } else if (event is getListSosEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield SosProgressState();
      SosRespon sosRespon =
          await SosApi().getDataSos(offset, 'listSos', modelFilter);
      if (sosRespon.success!) {
        listSos = sosRespon.dataSos;
        yield getListSosSuccessState(event, listSos);
      } else {
        yield SosErrorState();
      }
    } else if (event is getListSosKlienEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield SosProgressState();
      SosRespon sosRespon =
          await SosApi().getDataklienSos(offset, 'listSos', modelFilter);
      if (sosRespon.success!) {
        listSos = sosRespon.dataSos;
        yield getListSosSuccessState(event, listSos);
      } else {
        yield SosErrorState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listSos);
        SosRespon sosRespon =
          await SosApi().getDataSos(offset, 'listSos', modelFilter);
          if (sosRespon.success!){
            listSos!.addAll(sosRespon.dataSos!);
          }
          yield getListSosSuccessState(event,listSos);
      }
    }else if (event is loadMoreKlienEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listSos);
        SosRespon sosRespon =
          await SosApi().getDataklienSos(offset, 'listSos', modelFilter);
          if (sosRespon.success!){
            listSos!.addAll(sosRespon.dataSos!);
          }
          yield getListSosSuccessState(event,listSos);
      }
    }
  }
}
