import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mJadwalShift.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart' as shift;
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/shiftApi.dart';
import 'package:absenkuv3/Repository/Service/tukarShiftApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class ShiftV2Event {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? keyword;
  bool? lokasiKantor;
}

class getListShiftV2Event extends ShiftV2Event {
  ModelFilter modelFilter;
  getListShiftV2Event(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class getJadwalShiftV2Event extends ShiftV2Event {
  getJadwalShiftV2Event(BuildContext _context, String _keyword, bool _lokasiKantor) {
    context = _context;
    keyword = _keyword;
    lokasiKantor = _lokasiKantor;
  }
}

class loadMoreEvent extends ShiftV2Event {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class ShiftV2State {
  List<shift.DataShift>? data;
  Data? dataShift;
  // DataShift? dataAktivitas;
}

class getListShiftSuccessState extends ShiftV2State {
  getListShiftSuccessState(ShiftV2Event _event, List<shift.DataShift>? _data) {
    data = _data;
  }
}

class getListJadwalShiftSuccessState extends ShiftV2State {
  getListJadwalShiftSuccessState(ShiftV2Event _event, Data? _data) {
    dataShift = _data;
  }
}

class ShiftProgressV2State extends ShiftV2State {}

class LoadMoreProgressState extends ShiftV2State {
  LoadMoreProgressState(List<shift.DataShift>? _data) {
    data = _data;
  }
}

class ShiftErrorState extends ShiftV2State {}

class ShiftV2Bloc extends Bloc<ShiftV2Event, ShiftV2State> {
  ShiftV2State? initialState;
  List<shift.DataShift>? listShift;
  Data? listJadwalShift;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  ShiftV2Bloc(ShiftV2State initialState) : super(initialState);

  @override
  Stream<ShiftV2State> mapEventToState(ShiftV2Event event) async* {
    if (event is getListShiftV2Event) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield ShiftProgressV2State();
      shift.ShiftRespon shiftRespon =
          await TukarShiftApi().getDataShift(offset, modelFilter);
      if (shiftRespon.success!) {
        listShift = shiftRespon.data;
        yield getListShiftSuccessState(event, listShift);
      } else
        yield ShiftErrorState();
    } else if (event is getJadwalShiftV2Event) {
      offset = 0;
      yield ShiftProgressV2State();
      JadwalShift jadwalShift =
          await ShiftApi().getJadwalShift(limit, offset, event.keyword,event.lokasiKantor!);
      debugPrint('jadwalShift ' + jadwalShift.toString());
      if (jadwalShift.success!) {
        listJadwalShift = jadwalShift.data;
        yield getListJadwalShiftSuccessState(event, listJadwalShift);
      } else
        yield ShiftErrorState();
    } 
    else if (event is loadMoreEvent) {
      debugPrint(event.toString());
      debugPrint('Load');
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listShift);
        shift.ShiftRespon shiftRespon =
            await TukarShiftApi().getDataShift(offset, modelFilter);
        if (shiftRespon.success!) {
          listShift!.addAll(shiftRespon.data!);
          yield getListShiftSuccessState(event, listShift);
        } else {
          yield getListShiftSuccessState(event, listShift);
        }
      }
    }
  }
}
