import 'package:flutter_bloc/flutter_bloc.dart';

// Event
abstract class SearchEvent {}

class SearchTextChanged extends SearchEvent {
  final String searchText;
  SearchTextChanged(this.searchText);
}

// State
abstract class SearchState {}

class SearchInitial extends SearchState {}

class SearchResult extends SearchState {
  final String searchText;

  SearchResult(this.searchText);
}

// Bloc
class SearchBloc extends Bloc<SearchEvent, SearchState> {
  SearchBloc() : super(SearchInitial());

  @override
  Stream<SearchState> mapEventToState(SearchEvent event) async* {
    if (event is SearchTextChanged) {
      yield SearchResult(event.searchText);
    }
  }
}
