import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class TotalDataLayananDetailEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getTotalDataLayananDetailEvent extends TotalDataLayananDetailEvent {
  String? idPipelineMain;
  getTotalDataLayananDetailEvent(BuildContext _context, this.idPipelineMain) {
    context = _context;
  }
}

abstract class TotalDataLayananDetailState {
  TotalDataLayananDetail? dataTotalDataLayananDetail;
}

class getTotalDataLayananDetailSuccessState extends TotalDataLayananDetailState {
  getTotalDataLayananDetailSuccessState(TotalDataLayananDetail _dataTotal) {
    dataTotalDataLayananDetail = _dataTotal;
  }
}

class TotalDataLayananDetailProgressState extends TotalDataLayananDetailState {}

class TotalDataLayananDetailErrorState extends TotalDataLayananDetailState {}

class TotalDataLayananDetailBloc extends Bloc<TotalDataLayananDetailEvent, TotalDataLayananDetailState> {

  TotalDataLayananDetailBloc(TotalDataLayananDetailState initialState) : super(initialState);

  @override
  Stream<TotalDataLayananDetailState> mapEventToState(TotalDataLayananDetailEvent event) async* {
    if (event is getTotalDataLayananDetailEvent) {
      yield TotalDataLayananDetailProgressState();
      TotalDataLayananRespon dataDataLayananDetail = await SalesActivityApi().getTotalDataLayananDetail(event.idPipelineMain);
      if (dataDataLayananDetail.success!) {
        yield getTotalDataLayananDetailSuccessState(dataDataLayananDetail.totalDataLayananDetail!);
      } else
        yield TotalDataLayananDetailErrorState();
    }
  }
}
