import 'package:absenkuv3/Repository/Model/mBadgepercolumn.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mMasterTahapan.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:absenkuv3/Repository/Service/notifApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class TahapanEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class TahapanState {}

class GetTahapanEvent extends TahapanEvent {
  ModelFilter? modelFilter;
  String? selectedTahapan;
  String? idSelectedTahapan;
  GetTahapanEvent(BuildContext _context, this.modelFilter, {this.selectedTahapan, this.idSelectedTahapan}) {
    context = _context;
  }
}

class SelectedTahapanEvent extends TahapanEvent {
  List<DataTahapan>? dataColumn;
  String? selected;
  String? idSelected;
  String? bgColor;
  String? textColor;
  ModelFilter? modelFilter;
  SelectedTahapanEvent(List<DataTahapan> _dataColumn, String _selected, String _idSelected, String _bgColor, String _textColor, ModelFilter _modelFilter) {
    dataColumn = _dataColumn;
    selected = _selected;
    idSelected = _idSelected;
    bgColor = _bgColor;
    textColor = _textColor;
    modelFilter = _modelFilter;
  }
}

class TahapanSuccessState extends TahapanState {
  List<DataTahapan>? dataColumn;
  String? selected;
  String? idSelected;
  String? bgColor;
  String? textColor;
  ModelFilter? modelFilter;
  TahapanSuccessState(this.dataColumn, this.selected, this.idSelected, this.bgColor, this.textColor, this.modelFilter) {}
}

class TahapanProgressState extends TahapanState {}

class TahapanFailedState extends TahapanState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  TahapanFailedState(this.message, this.scaffoldKey) {
    // showSnackBarDelayed(scaffoldKey, message);
  }
}

class TahapanBloc extends Bloc<TahapanEvent, TahapanState> {
  TahapanBloc(TahapanState initialState) : super(initialState);

  @override
  Stream<TahapanState> mapEventToState(TahapanEvent event) async* {
    if (event is GetTahapanEvent) {
      yield TahapanProgressState();
      MasterTahapanRespon dataTahapanRespon = await SalesActivityApi().getDataTahapan(event.modelFilter!.monthYear!.month.toString(), event.modelFilter!.monthYear!.year.toString());
      if (dataTahapanRespon.success!) {
        if(event.idSelectedTahapan == null){
          yield TahapanSuccessState(
              dataTahapanRespon.data, dataTahapanRespon.data![0].value,
              dataTahapanRespon.data![0].id, dataTahapanRespon.data![0].warna,
              dataTahapanRespon.data![0].warnaText, event.modelFilter);
        }else{
          DataTahapan _selectedTahapan = dataTahapanRespon.data!.where((element) => element.id == event.idSelectedTahapan).first;
          yield TahapanSuccessState(
              dataTahapanRespon.data, event.selectedTahapan,
              event.idSelectedTahapan, _selectedTahapan.warna,
              _selectedTahapan.warnaText, event.modelFilter);
        }
      }else
        yield TahapanFailedState(dataTahapanRespon.message, event.scaffoldKey);
    } else if(event is SelectedTahapanEvent){
      yield TahapanSuccessState(event.dataColumn, event.selected, event.idSelected, event.bgColor, event.textColor, event.modelFilter);
    }
  }
}
