import 'package:absenkuv3/Repository/Model/SalesActivity/mPerusahaan.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class PelangganEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetPelangganEvent extends PelangganEvent {
  String? idPelanggan;
  String? idPipelineMain;
  GetPelangganEvent(BuildContext _context, this.idPelanggan, this.idPipelineMain) {
    context = _context;
  }
}

abstract class PelangganState {
  List<DataPerusahaan>? dataPelanggan;
}

class getPelangganSuccessState extends PelangganState {
  getPelangganSuccessState(List<DataPerusahaan> _dataTotal) {
    dataPelanggan = _dataTotal;
  }
}

class PelangganProgressState extends PelangganState {}

class PelangganErrorState extends PelangganState {}

class PelangganBloc extends Bloc<PelangganEvent, PelangganState> {

  PelangganBloc(PelangganState initialState) : super(initialState);

  @override
  Stream<PelangganState> mapEventToState(PelangganEvent event) async* {
    if (event is GetPelangganEvent) {
      yield PelangganProgressState();
      PerusahaanRespon dataKanban = await SalesActivityApi().getPelanggan(event.idPelanggan, event.idPipelineMain);
      if (dataKanban.success!) {
        yield getPelangganSuccessState(dataKanban.data!);
      } else
        yield PelangganErrorState();
    }
  }
}
