import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DetailDailyAktivitasSalesEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListDetailDailyAktivitasSalesEvent extends DetailDailyAktivitasSalesEvent {
  String? status;
  DataDailyAktivitasSales? param;
  getListDetailDailyAktivitasSalesEvent(BuildContext _context, this.status, this.param) {
    context = _context;
  }
}

class getListDetailDailyAktivitasSalesByIdEvent extends DetailDailyAktivitasSalesEvent {
  String? status;
  DataDailyAktivitasSales? param;
  getListDetailDailyAktivitasSalesByIdEvent(BuildContext _context, this.status, this.param) {
    context = _context;
  }
}

abstract class DetailDailyAktivitasSalesState {
  List<DataDailyAktivitasSales>? data;
}

class getListDetailDailyAktivitasSalesSuccessState extends DetailDailyAktivitasSalesState {
  getListDetailDailyAktivitasSalesSuccessState(DetailDailyAktivitasSalesEvent _event, List<DataDailyAktivitasSales>? _data) {
    data = _data;
  }
}

class DetailDailyAktivitasSalesProgressState extends DetailDailyAktivitasSalesState {}

class DetailDailyAktivitasSalesErrorState extends DetailDailyAktivitasSalesState {}

class DetailDailyAktivitasSalesEmptyState extends DetailDailyAktivitasSalesState {}

class DetailDailyAktivitasSalesBloc extends Bloc<DetailDailyAktivitasSalesEvent, DetailDailyAktivitasSalesState> {
  DetailDailyAktivitasSalesState? initialState;
  List<DataDailyAktivitasSales>? listDataAktivitasSales;

  DetailDailyAktivitasSalesBloc(DetailDailyAktivitasSalesState initialState) : super(initialState);

  @override
  Stream<DetailDailyAktivitasSalesState> mapEventToState(DetailDailyAktivitasSalesEvent event) async* {
    if (event is getListDetailDailyAktivitasSalesEvent) {
      yield DetailDailyAktivitasSalesProgressState();
      DailyAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDetailDailyAktivitasSales(
          event.status,
          event.param!.userId,
          event.param!.idPipelineMain,
          event.param!.idPipelineMainLog,
          event.param!.idPelanggan,
          event.param!.tanggal,
          event.param!.jam,
          event.param!.tabel);
      if (dataAktivitasSalesRespon.success!) {
        listDataAktivitasSales = dataAktivitasSalesRespon.dataDailyAktivitasSales;
        yield getListDetailDailyAktivitasSalesSuccessState(event, listDataAktivitasSales);
      } else if(!dataAktivitasSalesRespon.success!)
        yield DetailDailyAktivitasSalesEmptyState();
      else yield DetailDailyAktivitasSalesErrorState();
    }
    else if (event is getListDetailDailyAktivitasSalesByIdEvent) {
      yield DetailDailyAktivitasSalesProgressState();
      DailyAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDetailDailyAktivitasSalesById(
          event.status,
          event.param!.userId,
          event.param!.idPipelineMain,
          event.param!.idPipelineMainLog,
          event.param!.idPelanggan,
          event.param!.tanggal,
          event.param!.jam,
          event.param!.tabel);
      if (dataAktivitasSalesRespon.success!) {
        listDataAktivitasSales = dataAktivitasSalesRespon.dataDailyAktivitasSales;
        yield getListDetailDailyAktivitasSalesSuccessState(event, listDataAktivitasSales);
      } else if(!dataAktivitasSalesRespon.success!)
        yield DetailDailyAktivitasSalesEmptyState();
      else yield DetailDailyAktivitasSalesErrorState();
    }
  }
}
