import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DetailDailyAktivitasSalesBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataDailyAktivitasSalesEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListDataDailyAktivitasSalesEvent extends DataDailyAktivitasSalesEvent {
  String? status;
  ModelFilter? modelFilter;
  getListDataDailyAktivitasSalesEvent(BuildContext _context, this.status, this.modelFilter) {
    context = _context;
  }
}

class getListDataDailyAktivitasSalesOnDetailEvent extends DataDailyAktivitasSalesEvent {
  String? status;
  getListDataDailyAktivitasSalesOnDetailEvent(BuildContext _context, this.status) {
    context = _context;
  }
}

class loadMoreEvent extends DataDailyAktivitasSalesEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

class SetujuiActivitySalesEvent extends DataDailyAktivitasSalesEvent {
  String? status;
  DataDailyAktivitasSales? param;
  String pageActionFrom;
  SetujuiActivitySalesEvent(BuildContext _context, this.status, this.param, this.pageActionFrom) {
    context = _context;
  }
}

class TolakActivitySalesEvent extends DataDailyAktivitasSalesEvent {
  String? status;
  DataDailyAktivitasSales? param;
  String pageActionFrom;
  TolakActivitySalesEvent(BuildContext _context, this.status, this.param, this.pageActionFrom) {
    context = _context;
  }
}

abstract class DataDailyAktivitasSalesState {
  List<DataDailyAktivitasSales>? data;
}

class getListDataDailyAktivitasSalesSuccessState extends DataDailyAktivitasSalesState {
  getListDataDailyAktivitasSalesSuccessState(DataDailyAktivitasSalesEvent _event, List<DataDailyAktivitasSales>? _data) {
    data = _data;
  }
}

class DataDailyAktivitasSalesProgressState extends DataDailyAktivitasSalesState {}

class LoadMoreProgressState extends DataDailyAktivitasSalesState {
  LoadMoreProgressState(List<DataDailyAktivitasSales>? _data) {
    data = _data;
  }
}

class DataDailyAktivitasSalesErrorState extends DataDailyAktivitasSalesState {}

class DataDailyAktivitasSalesEmptyState extends DataDailyAktivitasSalesState {}

class DataDailyAktivitasSalesBloc extends Bloc<DataDailyAktivitasSalesEvent, DataDailyAktivitasSalesState> {
  ModelFilter? modelFilter;
  DataDailyAktivitasSalesState? initialState;
  List<DataDailyAktivitasSales>? listDataAktivitasSales;
  String? status;
  int offset = 0;
  int limit = ServerInfo.limit;

  DataDailyAktivitasSalesBloc(DataDailyAktivitasSalesState initialState) : super(initialState);

  @override
  Stream<DataDailyAktivitasSalesState> mapEventToState(DataDailyAktivitasSalesEvent event) async* {
    if (event is getListDataDailyAktivitasSalesEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      status = event.status;
      yield DataDailyAktivitasSalesProgressState();
      DailyAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDataDailyAktivitasSales(event.status, offset, modelFilter);
      if (dataAktivitasSalesRespon.success!) {
        listDataAktivitasSales = dataAktivitasSalesRespon.dataDailyAktivitasSales;
        yield getListDataDailyAktivitasSalesSuccessState(event, listDataAktivitasSales);
      } else if(!dataAktivitasSalesRespon.success!)
        yield DataDailyAktivitasSalesEmptyState();
      else yield DataDailyAktivitasSalesErrorState();
    }
    else if (event is loadMoreEvent) {
      if (event.scrollController.offset >= event.scrollController.position.maxScrollExtent && !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listDataAktivitasSales);
        DailyAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDataDailyAktivitasSales(status, offset, modelFilter);
        if (dataAktivitasSalesRespon.success!) {
          listDataAktivitasSales!.addAll(dataAktivitasSalesRespon.dataDailyAktivitasSales!);
        }
        yield getListDataDailyAktivitasSalesSuccessState(event, listDataAktivitasSales);
      }
    }else if(event is SetujuiActivitySalesEvent) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().setujuiActivity(event.param!);
      if(basicRespon.success!){
        event.param!.status!.status = 'approve';
      }
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai'){
          // BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
          //     getListIzinPegawaiEvent(
          //         event.context, modelFilter != null ? modelFilter : null));
        }else if (event.pageActionFrom == 'detailActivity') {
          BlocProvider.of<DetailDailyAktivitasSalesBloc>(event.context!)
              .add(getListDetailDailyAktivitasSalesEvent(event.context!, event.param!.status!.status, event.param));
        }
      });
    }
    else if(event is TolakActivitySalesEvent) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().tolakActivity(event.param!);
      if(basicRespon.success!){
        event.param!.status!.status = 'tolak';
      }
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai'){
          // BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
          //     getListIzinPegawaiEvent(
          //         event.context, modelFilter != null ? modelFilter : null));
        }else if (event.pageActionFrom == 'detailActivity') {
          BlocProvider.of<DetailDailyAktivitasSalesBloc>(event.context!)
              .add(getListDetailDailyAktivitasSalesEvent(event.context!, event.param!.status!.status, event.param));
        }
      });
    }else if(event is getListDataDailyAktivitasSalesOnDetailEvent){
      offset = 0;
      status = event.status;
      yield DataDailyAktivitasSalesProgressState();
      DailyAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDataDailyAktivitasSales(event.status, offset, modelFilter);
      if (dataAktivitasSalesRespon.success!) {
        listDataAktivitasSales = dataAktivitasSalesRespon.dataDailyAktivitasSales;
        yield getListDataDailyAktivitasSalesSuccessState(event, listDataAktivitasSales);
      } else if(!dataAktivitasSalesRespon.success!)
        yield DataDailyAktivitasSalesEmptyState();
      else yield DataDailyAktivitasSalesErrorState();
    }
  }
}
