import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class CardItemEvent {
  BuildContext? context;
}

class GantiStatusEvent extends CardItemEvent {
  String status;
  GantiStatusEvent(BuildContext? _context, this.status) {
    context = _context;
  }
}

abstract class CardItemState {
  String? status;
}

class GantiStatusSuccess extends CardItemState {
  GantiStatusSuccess(String? _status) {
    status = _status;
  }
}

class GantiStatusError extends CardItemState {}

class CardItemReimbursementBloc extends Bloc<CardItemEvent, CardItemState> {
  String? status;
  CardItemReimbursementBloc(CardItemState initialState) : super(initialState);

  @override
  Stream<CardItemState> mapEventToState(CardItemEvent event) async* {
    if (event is GantiStatusEvent) {
      status = event.status;
      yield GantiStatusSuccess(status);
    }
  }
}

class CardItemReimbursementaBloc extends Bloc<CardItemEvent, CardItemState> {
  CardItemReimbursementaBloc(CardItemState initialState) : super(initialState);

  @override
  Stream<CardItemState> mapEventToState(CardItemEvent event) {
    throw UnimplementedError();
  }
}
