import 'package:absenkuv3/Repository/Model/mPkwt.dart';
import 'package:absenkuv3/Repository/Service/pkwtApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailPkwtEvent{}

class GetDetailPkwt extends DetailPkwtEvent{
  String? id;
  GetDetailPkwt(this.id);
}

abstract class DetailPkwtState{}

class DetailPkwtProgress extends DetailPkwtState{}

class DetailPkwtSuccess extends DetailPkwtState{
  PkwtRespon pkwtRespon;
  DetailPkwtSuccess(this.pkwtRespon);
}
class DetailPkwtError extends DetailPkwtState{}

class DetailPkwtBloc extends Bloc<DetailPkwtEvent,DetailPkwtState>{
  DetailPkwtBloc(DetailPkwtState initialState):super(initialState);
  @override
  Stream<DetailPkwtState> mapEventToState(DetailPkwtEvent event)async*{
    if(event is GetDetailPkwt){
      yield DetailPkwtProgress();
        PkwtRespon pkwtRespon = await PkwtApi().getDetailDataPkwt(event.id);
        if(pkwtRespon.success!)yield DetailPkwtSuccess(pkwtRespon);
        else yield DetailPkwtError();
    }
  }
}
