import 'package:absenkuv3/Repository/Model/mPengaturan.dart';
import 'package:absenkuv3/Repository/Service/tukarShiftApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class PengaturanEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class PengaturanState {}

class GetPengaturan extends PengaturanEvent {
  GetPengaturan(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class GetSuccessPengaturan extends PengaturanState {
  Pengaturan? dataDashboard;
  GetSuccessPengaturan(this.dataDashboard) {}
}

class GetProgressPengaturan extends PengaturanState {}

class GetFailedPengaturan extends PengaturanState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailedPengaturan(this.message, this.scaffoldKey) {
    // showSnackBarDelayed(scaffoldKey, message);
  }
}

class PengaturanBloc extends Bloc<PengaturanEvent, PengaturanState> {
  PengaturanBloc(PengaturanState initialState) : super(initialState);

  @override
  Stream<PengaturanState> mapEventToState(PengaturanEvent event) async* {
    if (event is GetPengaturan) {
      yield GetProgressPengaturan();
      debugPrint('GetPengaturan');
      Pengaturan dashboardRespon = await TukarShiftApi().pengaturan();
      debugPrint(dashboardRespon.data.toString());
      if (dashboardRespon.success!)
        yield GetSuccessPengaturan(dashboardRespon);
      else
        yield GetFailedPengaturan(dashboardRespon.message, event.scaffoldKey);
    }
  }
}
