import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:absenkuv3/Repository/Service/patroliApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailPatroliEvent{}

class GetDetailPatroli extends DetailPatroliEvent{
  String? id;
  GetDetailPatroli(this.id);
}

abstract class DetailPatroliState{}
class DetailPatroliProgress extends DetailPatroliState{}
class DetailPatroliSuccess extends DetailPatroliState{
  CheckpointRespon checkpointRespon;
  DetailPatroliSuccess(this.checkpointRespon);
}
class DetailPatroliError extends DetailPatroliState{}
class DetailPatroliBloc extends Bloc<DetailPatroliEvent,DetailPatroliState>{
  DetailPatroliBloc(DetailPatroliState initialState):super(initialState);

  @override
  Stream<DetailPatroliState> mapEventToState(DetailPatroliEvent event)async*{
    if ( event is GetDetailPatroli){
      yield DetailPatroliProgress();
      CheckpointRespon checkpointRespon = await PatroliApi().getDataDetailChekpoint(event.id);
      if (checkpointRespon.success!)yield DetailPatroliSuccess(checkpointRespon);
      else yield DetailPatroliError();
    }
  }
}