import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class PengajuanKpiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class PengajuanKpi extends PengajuanKpiEvent {
  ModelPengajuanKpi modelpengajuanKpi;
  BuildContext? context;
  PengajuanKpi(this.modelpengajuanKpi, this.context);
}
class PengajuanKpiWithDataLampau extends PengajuanKpiEvent {
  ModelPengajuanKpi modelpengajuanKpi;
  BuildContext? context;
  PengajuanKpiWithDataLampau(this.modelpengajuanKpi, this.context);
}

abstract class PengajuanKpiState {}

class PengajuanKpiProgress extends PengajuanKpiState {}

class PengajuanKpiError extends PengajuanKpiState {}

class PengajuanKpiBloc extends Bloc<PengajuanKpiEvent, PengajuanKpiState> {
  PengajuanKpiBloc(PengajuanKpiState initialState) : super(initialState);

  @override
  Stream<PengajuanKpiState> mapEventToState(PengajuanKpiEvent event) async* {
    if (event is PengajuanKpi) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KpiApi().pengajuanKpi(event.modelpengajuanKpi);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigatePop(event.context));
          // BlocProvider.of<GetListkpiTeamBloc>(event.context!)
          //     .add(GetDataListKpiTeam(ModelFilterKpi(status: '5')));
          BlocProvider.of<GetListKpiBloc>(event.context!).add(GetDataListKpi(
                      ModelFilterKpi(monthYear: DateTime.now())));
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigateToHalamanPengajuanKpiTeam(event.context!, [
            event.modelpengajuanKpi.karyawan,
            event.modelpengajuanKpi.id_company,
            event.modelpengajuanKpi.bulan,
            event.modelpengajuanKpi.tahun
          ]));
        }
      }
    }else if (event is PengajuanKpiWithDataLampau) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KpiApi().pengajuanKpiWithDataLampau(event.modelpengajuanKpi);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigatePop(event.context));
          // BlocProvider.of<GetListkpiTeamBloc>(event.context!)
          //     .add(GetDataListKpiTeam(ModelFilterKpi(status: '5')));
          BlocProvider.of<GetListKpiBloc>(event.context!).add(GetDataListKpi(
                      ModelFilterKpi(monthYear: DateTime.now())));
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigateToHalamanPengajuanKpiTeam(event.context!, [
            event.modelpengajuanKpi.karyawan,
            event.modelpengajuanKpi.id_company,
            event.modelpengajuanKpi.bulan,
            event.modelpengajuanKpi.tahun
          ]));
        }
      }
    }
  }
}
