import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/MonitorAbsensi/monitorAbsenApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class MonitorListEvent {
  BuildContext? context;
  String? konteks;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class MonitorListState {
  List<DataRekapAbsensi>? dataMonitorList;
}

class GetMonitorListEvent extends MonitorListEvent {
  ModelFilter? modelFilter;
  GetMonitorListEvent(BuildContext _context, String _konteks,this.modelFilter) {
    context = _context;
    konteks = _konteks;
  }
}

class loadMoreEvent extends MonitorListEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController,String _konteks) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
    konteks=_konteks;
  }
}

class LoadMoreProgressState extends MonitorListState {
  LoadMoreProgressState(List<DataRekapAbsensi>? _data) {
    dataMonitorList = _data;
  }
}

class SuccessMonitorListState extends MonitorListState {
  SuccessMonitorListState(List<DataRekapAbsensi>? _dataMonitorList) {
    dataMonitorList = _dataMonitorList;
  }
}

class ProgressMonitorListState extends MonitorListState {}

class ErrorMonitorAbsenState extends MonitorListState {}

class MonitorListBloc extends Bloc<MonitorListEvent, MonitorListState> {
  MonitorListBloc(MonitorListState initialState) : super(initialState);
  List<DataRekapAbsensi>? dataMonitorList;
  int offset = 0;
  int limit = ServerInfo.limit;
  ModelFilter? modelFilter;
  @override
  Stream<MonitorListState> mapEventToState(MonitorListEvent event) async* {
    if (event is GetMonitorListEvent) {
      offset = 0;
      debugPrint(event.konteks! + ' konteks');
      debugPrint(offset.toString());
      modelFilter = event.modelFilter;
      yield ProgressMonitorListState();
      RekapAbsensiRespon data = await MonitorAbsenApi()
          .getDataListMonitor(modelFilter,event.konteks!, offset);
      if (data.success!) {
        dataMonitorList = data.data;
        yield SuccessMonitorListState(dataMonitorList);
      } else {
        yield ErrorMonitorAbsenState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(dataMonitorList);
        RekapAbsensiRespon data = await MonitorAbsenApi()
            .getDataListMonitor(modelFilter,event.konteks!, offset);
        if (data.success!) {
          dataMonitorList!.addAll(data.data!);
        }
        yield SuccessMonitorListState(dataMonitorList);
      }
    }
  }
}
