import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/Koordinator/Izin/BadgeNotifBloc.dart';
import 'package:absenkuv3/Bloc/Koordinator/Izin/DetailIzinBloc.dart';
import 'package:absenkuv3/Bloc/Koordinator/KoordinatorListBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/progress_dialog.dart';

abstract class IzinPegawaiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListIzinPegawaiKlienEvent extends IzinPegawaiKlienEvent {
  ModelFilter? modelFilter;
  String? idKlien;
  getListIzinPegawaiKlienEvent(
      BuildContext? _context, this.modelFilter, String? _idKlien) {
    context = _context;
    idKlien = _idKlien;
  }
}

class setujuiIzin extends IzinPegawaiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  String idKlien;
  BuildContext? contextSebelum;
  BuildContext? contextKoordinator;
  setujuiIzin(this.idIzin, this.context, this.scaffoldKey, this.pageActionFrom,
      this.idKlien, this.contextSebelum, this.contextKoordinator);
}

class MewakiliSetujuiIzin extends IzinPegawaiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  String idKlien;
  BuildContext? contextSebelum;
  BuildContext? contextKoordinator;
  MewakiliSetujuiIzin(
      this.idIzin,
      this.context,
      this.scaffoldKey,
      this.pageActionFrom,
      this.idKlien,
      this.contextSebelum,
      this.contextKoordinator);
}

class tolakIzin extends IzinPegawaiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  String idKlien;
  BuildContext? contextSebelum;
  BuildContext? contextKoordinator;
  tolakIzin(this.idIzin, this.context, this.scaffoldKey, this.pageActionFrom,
      this.idKlien, this.contextSebelum, this.contextKoordinator);
}

class MewakiliTolakIzin extends IzinPegawaiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  String idKlien;
  BuildContext? contextSebelum;
  BuildContext? contextKoordinator;
  MewakiliTolakIzin(
      this.idIzin,
      this.context,
      this.scaffoldKey,
      this.pageActionFrom,
      this.idKlien,
      this.contextSebelum,
      this.contextKoordinator);
}

class loadMoreEvent extends IzinPegawaiKlienEvent {
  late ScrollController scrollController;
  String? idKlien;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController, String? _idKlien) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
    idKlien = _idKlien;
  }
}

abstract class IzinPegawaiKlienState {
  List<DataIzin>? data;
  DataIzin? dataDetail;
}

class getListIzinKaryawanSuccessState extends IzinPegawaiKlienState {
  getListIzinKaryawanSuccessState(
      IzinPegawaiKlienEvent _event, List<DataIzin>? _data) {
    data = _data;
  }
}

class parseDataIzinPegawaiKlienState extends IzinPegawaiKlienState {
  parseDataIzinPegawaiKlienState(DataIzin _dataDetail) {
    dataDetail = _dataDetail;
  }
}

class IzinPegawaiKlienProgressState extends IzinPegawaiKlienState {}

class LoadMoreProgressState extends IzinPegawaiKlienState {
  LoadMoreProgressState(List<DataIzin>? _data) {
    data = _data;
  }
}

class IzinPegawaiErrorState extends IzinPegawaiKlienState {}

class IzinPegawaiKlienBloc
    extends Bloc<IzinPegawaiKlienEvent, IzinPegawaiKlienState> {
  final dateFormat = new DateFormat('yyyy-MM');
  IzinPegawaiKlienState? initialState;
  List<DataIzin>? listIzin;
  int offset = 0;
  int limit = ServerInfo.limit;
  ModelFilter? modelFilter;

  IzinPegawaiKlienBloc(IzinPegawaiKlienState initialState)
      : super(initialState);

  @override
  Stream<IzinPegawaiKlienState> mapEventToState(
      IzinPegawaiKlienEvent event) async* {
    if (event is getListIzinPegawaiKlienEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield IzinPegawaiKlienProgressState();
      IzinRespon izinRespon = await KoordinatorApi()
          .getDataIzin(offset, 'izinPegawai', modelFilter, event.idKlien!);
      if (izinRespon.success!) {
        listIzin = izinRespon.data;
        yield getListIzinKaryawanSuccessState(event, listIzin);
      } else
        yield IzinPegawaiErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listIzin);
        IzinRespon izinRespon = await KoordinatorApi()
            .getDataIzin(offset, 'izinPegawai', modelFilter, event.idKlien!);
        if (izinRespon.success!) {
          listIzin!.addAll(izinRespon.data!);
        }
        yield getListIzinKaryawanSuccessState(event, listIzin);
      }
    } else if (event is setujuiIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KoordinatorApi().setujuiIzinKlien(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai') {
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        } else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinKlienBloc>(event.context!)
              .add(GetDetailIzinKlien(event.idIzin, event.idKlien));
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
          print("konteks ${event.context}");
        }
      });
    } else if (event is MewakiliSetujuiIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KoordinatorApi().MewakiliSetujuiIzinKlien(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai') {
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        } else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinKlienBloc>(event.context!)
              .add(GetDetailIzinKlien(event.idIzin, event.idKlien));
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        }
      });
    } else if (event is MewakiliTolakIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KoordinatorApi().MewakiliTolakIzinKlien(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai') {
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        } else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinKlienBloc>(event.context!)
              .add(GetDetailIzinKlien(event.idIzin, event.idKlien));
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        }
      });
    } else if (event is tolakIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KoordinatorApi().tolakIzinKlien(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai') {
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        } else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinKlienBloc>(event.context!)
              .add(GetDetailIzinKlien(event.idIzin, event.idKlien));
          BlocProvider.of<IzinPegawaiKlienBloc>(event.context!).add(
              getListIzinPegawaiKlienEvent(event.context,
                  modelFilter != null ? modelFilter : null, event.idKlien));
          BlocProvider.of<BadgeNotifKlienBloc>(event.contextSebelum!)
              .add(GetBadgeKlien(event.contextSebelum!, event.idKlien));
          BlocProvider.of<KoordinatorListBloc>(event.contextKoordinator!).add(
              getListKoordinatorListEvent(
                  event.contextKoordinator!, ModelFilter()));
        }
      });
    }
  }
}
