import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailIzinKlienEvent {}

class GetDetailIzinKlien extends DetailIzinKlienEvent {
  String? idIzin;
  String? idKlien;
  GetDetailIzinKlien(this.idIzin, this.idKlien);
}

abstract class DetailIzinKlienState {}

class DetailIzinKlienProgress extends DetailIzinKlienState {}

class DetailIzinSuccess extends DetailIzinKlienState {
  IzinRespon izinRespon;
  DetailIzinSuccess(this.izinRespon);
}

class DetailIzinError extends DetailIzinKlienState {}

class DetailIzinKlienBloc
    extends Bloc<DetailIzinKlienEvent, DetailIzinKlienState> {
  DetailIzinKlienBloc(DetailIzinKlienState initialState) : super(initialState);

  @override
  Stream<DetailIzinKlienState> mapEventToState(
      DetailIzinKlienEvent event) async* {
    if (event is GetDetailIzinKlien) {
      yield DetailIzinKlienProgress();
      IzinRespon izinRespon = await KoordinatorApi()
          .getDataIzinDetail(event.idIzin, 'izinDetail', event.idKlien);
      if (izinRespon.success!)
        yield DetailIzinSuccess(izinRespon);
      else
        yield DetailIzinError();
    }
  }
}
