import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mBadgepercolumn.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeNotifKoordinatorEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgeNotifKoordinatorState {}

class GetBadgeKoordinator extends BadgeNotifKoordinatorEvent {
  GetBadgeKoordinator(
    BuildContext _context,
  ) {
    context = _context;
  }
}

class GetSuccessKoordinator extends BadgeNotifKoordinatorState {
  JumlahBadge? dataDashboard;
  GetSuccessKoordinator(this.dataDashboard) {}
}

class GetSuccessKoordinatorPerColumn extends BadgeNotifKoordinatorState {
  Badgepercolumn? dataColumn;
  GetSuccessKoordinatorPerColumn(this.dataColumn) {}
}

class GetProgressKoordinator extends BadgeNotifKoordinatorState {}

class GetFailed extends BadgeNotifKoordinatorState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailed(this.message, this.scaffoldKey) {}
}

class BadgeNotifKoordinatorBloc
    extends Bloc<BadgeNotifKoordinatorEvent, BadgeNotifKoordinatorState> {
  BadgeNotifKoordinatorBloc(BadgeNotifKoordinatorState initialState)
      : super(initialState);

  @override
  Stream<BadgeNotifKoordinatorState> mapEventToState(
      BadgeNotifKoordinatorEvent event) async* {
    if (event is GetBadgeKoordinator) {
      yield GetProgressKoordinator();
      JumlahBadge dashboardRespon =
          await KoordinatorApi().getDataBadgePerKoordinator();
      if (dashboardRespon.success!)
        yield GetSuccessKoordinator(dashboardRespon);
      else
        yield GetFailed(dashboardRespon.message, event.scaffoldKey);
    }
  }
}
