import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mBadgepercolumn.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeNotifKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgeNotifKlienState {}

class GetBadgeKlien extends BadgeNotifKlienEvent {
  String? idKlien;
  GetBadgeKlien(
    BuildContext _context,
    String _idKlien,
  ) {
    context = _context;
    idKlien = _idKlien;
  }
}

class GetSuccess extends BadgeNotifKlienState {
  JumlahBadge? dataDashboard;
  GetSuccess(this.dataDashboard) {}
}

class GetSuccessPerColumn extends BadgeNotifKlienState {
  Badgepercolumn? dataColumn;
  GetSuccessPerColumn(this.dataColumn) {}
}

class GetProgressKlien extends BadgeNotifKlienState {}

class GetFailed extends BadgeNotifKlienState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailed(this.message, this.scaffoldKey) {
    // showSnackBarDelayed(scaffoldKey, message);
  }
}

class BadgeNotifKlienBloc extends Bloc<BadgeNotifKlienEvent, BadgeNotifKlienState> {
  BadgeNotifKlienBloc(BadgeNotifKlienState initialState) : super(initialState);

  @override
  Stream<BadgeNotifKlienState> mapEventToState(
      BadgeNotifKlienEvent event) async* {
    if (event is GetBadgeKlien) {
      yield GetProgressKlien();
      JumlahBadge dashboardRespon =
          await KoordinatorApi().getDataBadgePerKlien(event.idKlien);
      if (dashboardRespon.success!)
        yield GetSuccess(dashboardRespon);
      else
        yield GetFailed(dashboardRespon.message, event.scaffoldKey);
    }
  }
}
