import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/izinApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import '../CustomFunction.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import '../NavigatorBloc.dart';
import 'DetailIzinBloc.dart';

abstract class IzinPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListIzinPegawaiEvent extends IzinPegawaiEvent {
  ModelFilter? modelFilter;
  getListIzinPegawaiEvent(BuildContext? _context, this.modelFilter) {
    context = _context;
  }
}

class setujuiIzin extends IzinPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  setujuiIzin(this.idIzin, this.context, this.scaffoldKey, this.pageActionFrom);
}

class MewakiliSetujuiIzin extends IzinPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  MewakiliSetujuiIzin(
      this.idIzin, this.context, this.scaffoldKey, this.pageActionFrom);
}

class tolakIzin extends IzinPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  tolakIzin(this.idIzin, this.context, this.scaffoldKey, this.pageActionFrom);
}

class MewakiliTolakIzin extends IzinPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  String pageActionFrom;
  MewakiliTolakIzin(
      this.idIzin, this.context, this.scaffoldKey, this.pageActionFrom);
}

class loadMoreEvent extends IzinPegawaiEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class IzinPegawaiState {
  List<DataIzin>? data;
  DataIzin? dataDetail;
}

class getListIzinKaryawanSuccessState extends IzinPegawaiState {
  getListIzinKaryawanSuccessState(
      IzinPegawaiEvent _event, List<DataIzin>? _data) {
    data = _data;
  }
}

class parseDataIzinPegawaiState extends IzinPegawaiState {
  parseDataIzinPegawaiState(DataIzin _dataDetail) {
    dataDetail = _dataDetail;
  }
}

class IzinPegawaiProgressState extends IzinPegawaiState {}

class LoadMoreProgressState extends IzinPegawaiState {
  LoadMoreProgressState(List<DataIzin>? _data) {
    data = _data;
  }
}

class IzinPegawaiErrorState extends IzinPegawaiState {}

class IzinPegawaiBloc extends Bloc<IzinPegawaiEvent, IzinPegawaiState> {
  final dateFormat = new DateFormat('yyyy-MM');
  IzinPegawaiState? initialState;
  List<DataIzin>? listIzin;
  int offset = 0;
  int limit = ServerInfo.limit;
  ModelFilter? modelFilter;

  IzinPegawaiBloc(IzinPegawaiState initialState) : super(initialState);

  @override
  Stream<IzinPegawaiState> mapEventToState(IzinPegawaiEvent event) async* {
    if (event is getListIzinPegawaiEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield IzinPegawaiProgressState();
      IzinRespon izinRespon =
          await IzinApi().getDataIzin(offset, 'izinPegawai', modelFilter);
      if (izinRespon.success!) {
        listIzin = izinRespon.data;
        yield getListIzinKaryawanSuccessState(event, listIzin);
      } else
        yield IzinPegawaiErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listIzin);
        IzinRespon izinRespon =
            await IzinApi().getDataIzin(offset, 'izinPegawai', modelFilter);
        if (izinRespon.success!) {
          listIzin!.addAll(izinRespon.data!);
        }
        yield getListIzinKaryawanSuccessState(event, listIzin);
      }
    } else if (event is setujuiIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await IzinApi().setujuiIzin(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai')
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinBloc>(event.context!)
              .add(GetDetailIzin(event.idIzin));
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
          print("konteks ${event.context}");
        }
      });
    } else if (event is MewakiliSetujuiIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await IzinApi().MewakiliSetujuiIzin(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai')
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinBloc>(event.context!)
              .add(GetDetailIzin(event.idIzin));
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        }
      });
    } else if (event is MewakiliTolakIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await IzinApi().MewakiliTolakIzin(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai')
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinBloc>(event.context!)
              .add(GetDetailIzin(event.idIzin));
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        }
      });
    } else if (event is tolakIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await IzinApi().tolakIzin(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if (event.pageActionFrom == 'listIzinPegawai')
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        else if (event.pageActionFrom == 'detailIzin') {
          BlocProvider.of<DetailIzinBloc>(event.context!)
              .add(GetDetailIzin(event.idIzin));
          BlocProvider.of<IzinPegawaiBloc>(event.context!).add(
              getListIzinPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
        }
      });
    }
  }
}
