import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';
abstract class DropdownPendidikanEvent {}

class GetDataDropdownPendidikan extends DropdownPendidikanEvent {}

class SelectDataDropdownPendidikan extends DropdownPendidikanEvent {
  JenisData selectedValue;
  SelectDataDropdownPendidikan(this.selectedValue);
}

abstract class DropdownPendidikanState {
    
}

class DropdownPendidikanProgressState extends DropdownPendidikanState {}

class DropdownPendidikanSuccessState extends DropdownPendidikanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownPendidikanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownPendidikanErrorState extends DropdownPendidikanState {}

class DropdownPendidikanBloc extends Bloc<DropdownPendidikanEvent, DropdownPendidikanState> {
  DropdownPendidikanBloc(DropdownPendidikanState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownPendidikanState> mapEventToState(DropdownPendidikanEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownPendidikan) {
      yield DropdownPendidikanProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisPendidikan();
      if (dropdownRespon!.data != null)
        yield DropdownPendidikanSuccessState(dropdownRespon!, null);
      else
        yield DropdownPendidikanErrorState();
    } else if (event is SelectDataDropdownPendidikan) {
      selectedValue = event.selectedValue;
      yield DropdownPendidikanSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
