import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownKabupatenEvent {}

class GetDataDropdownKabupaten extends DropdownKabupatenEvent {}

class SelectDataDropdownKabupaten extends DropdownKabupatenEvent {
  JenisData? selectedValue;
  SelectDataDropdownKabupaten(this.selectedValue);
}

abstract class DropdownKabupatenState {}

class SetProvinsi extends DropdownKabupatenEvent{
  String? idProvinsi;
  JenisData? selectedValue;
  SetProvinsi(this.idProvinsi, this.selectedValue);
}

class SetValueProvinsi extends DropdownKabupatenEvent{
  String? idProvinsi;
  JenisData? selectedValue;
  SetValueProvinsi(this.idProvinsi, this.selectedValue);
}

class ClearDataDropdownKabupaten extends DropdownKabupatenEvent {}

class DropdownKabupatenProgressState extends DropdownKabupatenState {}

class DropdownKabupatenSuccessState extends DropdownKabupatenState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKabupatenSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownKabupatenSetValueSuccessState extends DropdownKabupatenState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKabupatenSetValueSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownKabupatenErrorState extends DropdownKabupatenState {}

class DropdownKabupatenBloc extends Bloc<DropdownKabupatenEvent, DropdownKabupatenState> {
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;
  DropdownKabupatenBloc(DropdownKabupatenState initialState) : super(initialState);

  @override
  Stream<DropdownKabupatenState> mapEventToState(DropdownKabupatenEvent event) async* {
    // TODO: implement mapEventToState
    // if (event is GetDataDropdownKabupaten) {
    //   yield DropdownKabupatenProgressState();
    //   selectedValue = null;
    //   dropdownRespon = await AkunApi().getJenisKabupaten();
    //   if (dropdownRespon.data != null)
    //     yield DropdownKabupatenSuccessState(dropdownRespon, null);
    //   else
    //     yield DropdownKabupatenErrorState();
    // }
    if (event is SelectDataDropdownKabupaten) {
      selectedValue = event.selectedValue;
      yield DropdownKabupatenSuccessState(dropdownRespon!, selectedValue);
    }else if(event is SetProvinsi){
      selectedValue = null;
      yield DropdownKabupatenProgressState();
      dropdownRespon = await DropdownAkunApi().getJenisKota(event.idProvinsi);
      if (dropdownRespon!.data != null) {
        yield DropdownKabupatenSuccessState(
            dropdownRespon!, event.selectedValue);
      }
      else
        yield DropdownKabupatenErrorState();
    }else if(event is SetValueProvinsi){
      selectedValue = event.selectedValue;
      yield DropdownKabupatenProgressState();
      dropdownRespon = await DropdownAkunApi().getJenisKota(event.idProvinsi);
      print("ini selected bloc ${selectedValue}");
      print("ini respon kabkot bloc ${dropdownRespon}");
      if (dropdownRespon!.data != null) {
        yield DropdownKabupatenSetValueSuccessState(
            dropdownRespon!, event.selectedValue);
      }
      else
        yield DropdownKabupatenErrorState();
    }else if(event is ClearDataDropdownKabupaten){
      selectedValue = null;
      dropdownRespon = null;
      yield DropdownKabupatenProgressState();
    }
  }
}
