import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownJenisStatusEvent {}

class GetDataDropdownJenisStatus extends DropdownJenisStatusEvent {}

class SelectDataDropdownJenisStatus extends DropdownJenisStatusEvent {
  JenisData selectedValue;
  SelectDataDropdownJenisStatus(this.selectedValue);
}

abstract class DropdownJenisStatusState {}

class DropdownJenisStatusProgressState extends DropdownJenisStatusState {}

class DropdownJenisStatusSuccessState extends DropdownJenisStatusState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownJenisStatusSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownJenisStatusErrorState extends DropdownJenisStatusState {}

class DropdownJenisStatusBloc extends Bloc<DropdownJenisStatusEvent, DropdownJenisStatusState> {
  DropdownJenisStatusBloc(DropdownJenisStatusState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownJenisStatusState> mapEventToState(DropdownJenisStatusEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownJenisStatus) {
      yield DropdownJenisStatusProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisStatus();
      if (dropdownRespon!.data != null)
        yield DropdownJenisStatusSuccessState(dropdownRespon!, null);
      else
        yield DropdownJenisStatusErrorState();
    } else if (event is SelectDataDropdownJenisStatus) {
      selectedValue = event.selectedValue;
      yield DropdownJenisStatusSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
